package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 入库单导入对象 inboundTemplate
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public class InboundTemplateVO extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /** 编号 */
    private String id;

    /** 入库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入库日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "SAP No")
    private String sapNo;

    /** 货物名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** 货物名称 */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 货主ID */
    @Excel(name = "货主")
    private String ownerId;

    /** 批次ID 检索条件 */
    @Excel(name = "批号")
    private String batchId;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Long plannedQuantity;

    /** 入库单号 检索条件 */
    @Excel(name = "单号")
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号")
    private String systemNo;

    /** 入库类型 字典，检索条件 */
//    @Excel(name = "入库类型")
    private String orderTypeId;

    @Excel(name = "件重")
    private Double unitWeight;

    /** 约数 */
    @Excel(name = "约数")
    private Long divisor;

    /** 实际件数 */
    @Excel(name = "实际件数")
    private Long actualPackages;

    /** 实际数量 */
    @Excel(name = "实发数量")
    private Long actualQuantity;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库")
    private String warehouseId;

    /** 库位ID 检索条件 */
    @Excel(name = "库位")
    private String locationId;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色")
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    /** 单价 */
    @Excel(name = "单价")
    private Long unitPrice;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 订单类型 字典，检索条件 */
    @Excel(name = "订单类型")
    private String orderType;

    /** 收货人 */
    @Excel(name = "收货人")
    private String receivedBy;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String remark2;

    /** 负责人 暂无用 */
//    @Excel(name = "负责人 暂无用")
    private String opUserName;

    /** 计划件数 暂无用 */
    //  @Excel(name = "件数")
    private Long plannedPackages;

    /** 排序号 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;


    private String updateUserCode;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSystemNo() {
        return systemNo;
    }

    public void setSystemNo(String systemNo) {
        this.systemNo = systemNo;
    }

    public String getOrderTypeId() {
        return orderTypeId;
    }

    public void setOrderTypeId(String orderTypeId) {
        this.orderTypeId = orderTypeId;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Date getInboundDate() {
        return inboundDate;
    }

    public void setInboundDate(Date inboundDate) {
        this.inboundDate = inboundDate;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getRemark2() {
        return remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getSapNo() {
        return sapNo;
    }

    public void setSapNo(String sapNo) {
        this.sapNo = sapNo;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getOpUserName() {
        return opUserName;
    }

    public void setOpUserName(String opUserName) {
        this.opUserName = opUserName;
    }

    public Long getPlannedQuantity() {
        return plannedQuantity;
    }

    public void setPlannedQuantity(Long plannedQuantity) {
        this.plannedQuantity = plannedQuantity;
    }

    public Long getActualQuantity() {
        return actualQuantity;
    }

    public void setActualQuantity(Long actualQuantity) {
        this.actualQuantity = actualQuantity;
    }

    public Long getPlannedPackages() {
        return plannedPackages;
    }

    public void setPlannedPackages(Long plannedPackages) {
        this.plannedPackages = plannedPackages;
    }

    public Long getActualPackages() {
        return actualPackages;
    }

    public void setActualPackages(Long actualPackages) {
        this.actualPackages = actualPackages;
    }

    public Long getDivisor() {
        return divisor;
    }

    public void setDivisor(Long divisor) {
        this.divisor = divisor;
    }

    public Long getLabelColor() {
        return labelColor;
    }

    public void setLabelColor(Long labelColor) {
        this.labelColor = labelColor;
    }

    public String getVoucherNumber() {
        return voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public Long getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Long unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getReceivedBy() {
        return receivedBy;
    }

    public void setReceivedBy(String receivedBy) {
        this.receivedBy = receivedBy;
    }

    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    public String getUpdateUserCode() {
        return updateUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) {
        this.updateUserCode = updateUserCode;
    }

    public Long getSortNo() {
        return sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    public String getTsCode() {
        return tsCode;
    }

    public void setTsCode(String tsCode) {
        this.tsCode = tsCode;
    }

    public Double getUnitWeight() {
        return unitWeight;
    }

    public void setUnitWeight(Double unitWeight) {
        this.unitWeight = unitWeight;
    }

    @Override
    public String toString() {
        return "InboundTemplateVO{" +
                "id='" + id + '\'' +
                ", inboundDate=" + inboundDate +
                ", sapNo='" + sapNo + '\'' +
                ", materialName='" + materialName + '\'' +
                ", tsCode='" + tsCode + '\'' +
                ", batchId='" + batchId + '\'' +
                ", plannedQuantity=" + plannedQuantity +
                ", orderId='" + orderId + '\'' +
                ", systemNo='" + systemNo + '\'' +
                ", orderTypeId='" + orderTypeId + '\'' +
                ", unitWeight=" + unitWeight +
                ", divisor=" + divisor +
                ", actualPackages=" + actualPackages +
                ", actualQuantity=" + actualQuantity +
                ", warehouseId='" + warehouseId + '\'' +
                ", locationId='" + locationId + '\'' +
                ", labelColor=" + labelColor +
                ", voucherNumber='" + voucherNumber + '\'' +
                ", unitPrice=" + unitPrice +
                ", remark='" + remark + '\'' +
                ", orderType='" + orderType + '\'' +
                ", receivedBy='" + receivedBy + '\'' +
                ", remark2='" + remark2 + '\'' +
                ", ownerId='" + ownerId + '\'' +
                ", opUserName='" + opUserName + '\'' +
                ", plannedPackages=" + plannedPackages +
                ", sortNo=" + sortNo +
                ", createUserCode='" + createUserCode + '\'' +
                ", updateUserCode='" + updateUserCode + '\'' +
                '}';
    }
}
