
import request from '@/utils/request'

// 查询库位列表
export function listLocations(query) {
  return request({
    url: '/inventory/locations/list',
    method: 'get',
    params: query
  })
}

// 查询库位详细
export function getLocations(id) {
  return request({
    url: '/inventory/locations/' + id,
    method: 'get'
  })
}

// 新增库位
export function addLocations(data) {
  return request({
    url: '/inventory/locations',
    method: 'post',
    data: data
  })
}

// 修改库位
export function updateLocations(data) {
  return request({
    url: '/inventory/locations',
    method: 'put',
    data: data
  })
}

// 删除库位
export function delLocations(id) {
  return request({
    url: '/inventory/locations/' + id,
    method: 'delete'
  })
}
