package com.ruoyi.web.controller.inventory;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.InventoryTransactions;
import com.ruoyi.inventory.service.IInventoryTransactionsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 库存事务Controller
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/transactions")
public class InventoryTransactionsController extends BaseController
{
    @Autowired
    private IInventoryTransactionsService inventoryTransactionsService;

    /**
     * 查询库存事务列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:list')")
    @GetMapping("/list")
    public TableDataInfo list(InventoryTransactions inventoryTransactions)
    {
        startPage();
        List<InventoryTransactions> list = inventoryTransactionsService.selectInventoryTransactionsList(inventoryTransactions);
        return getDataTable(list);
    }

    /**
     * 导出库存事务列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:export')")
    @Log(title = "库存事务", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, InventoryTransactions inventoryTransactions)
    {
        List<InventoryTransactions> list = inventoryTransactionsService.selectInventoryTransactionsList(inventoryTransactions);
        ExcelUtil<InventoryTransactions> util = new ExcelUtil<InventoryTransactions>(InventoryTransactions.class);
        util.exportExcel(response, list, "库存事务数据");
    }

    /**
     * 获取库存事务详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(inventoryTransactionsService.selectInventoryTransactionsById(id));
    }

    /**
     * 新增库存事务
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:add')")
    @Log(title = "库存事务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody InventoryTransactions inventoryTransactions)
    {
        return toAjax(inventoryTransactionsService.insertInventoryTransactions(inventoryTransactions));
    }

    /**
     * 修改库存事务
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:edit')")
    @Log(title = "库存事务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody InventoryTransactions inventoryTransactions)
    {
        return toAjax(inventoryTransactionsService.updateInventoryTransactions(inventoryTransactions));
    }

    /**
     * 删除库存事务
     */
    @PreAuthorize("@ss.hasPermi('inventory:transactions:remove')")
    @Log(title = "库存事务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(inventoryTransactionsService.deleteInventoryTransactionsByIds(ids));
    }
}
