package com.ruoyi.inventory.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库存对象 inventory
 *
 * @author ruoyi
 * @date 2025-12-03
 */
public class Inventory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 库存类别1普通2退库 */
    @Excel(name = "库存类别1普通2退库")
    private Long inventoryType;

    /** 入库单号 */
    @Excel(name = "入库单号")
    private String orderId;

    /** 货物名称 */
    private String orderName;
    /** 物料ID 检索条件 */
    @Excel(name = "物料ID 检索条件")
    private String materialId;
    /** 货物名称 */
    private String materialName;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchId;
    /** 批次ID 检索条件 */
    @Excel(name = "仓库ID ")
    private String warehousesId;
    /** 仓库编码 检索条件 */
    private String warehousesCode;
    /** 仓库编码 检索条件 */
    private String warehousesName;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID 检索条件")
    private String locationId;
    /** 库位名称 */
    private String locationName;

    /** 货主ID 检索条件 */
    @Excel(name = "货主ID 检索条件")
    private String ownerId;

    private String ownerName;
    /** 库存数量 */
    @Excel(name = "库存数量")
    private Long quantity;

    /** 锁定数量 */
    @Excel(name = "锁定数量")
    private Long lockedQuantity;

    /** 单位重量 */
    @Excel(name = "单位重量")
    private Long unitWeight;

    /** 总重量 暂无用 */
    @Excel(name = "总重量 暂无用")
    private Long totalWeight;

    /** 总体积 暂无用 */
    @Excel(name = "总体积 暂无用")
    private Long totalVolume;

    /** 生产日期 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生产日期 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date productionDate;

    /** 失效日期 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "失效日期 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDate;

    /** 库存状态 0-已出库 1-正常 字典，检索条件 */
    @Excel(name = "库存状态 0-已出库 1-正常 字典，检索条件")
    private Long inventoryStatus;

    /** 最后入库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后入库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastInboundTime;

    /** 最后出库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后出库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lastOutboundTime;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 预警类型 */
    private String alertType;

    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getWarehousesName() {
        return warehousesName;
    }

    public void setWarehousesName(String warehousesName) {
        this.warehousesName = warehousesName;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getWarehousesCode() {
        return warehousesCode;
    }

    public void setWarehousesCode(String warehousesCode) {
        this.warehousesCode = warehousesCode;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getWarehousesId() {
        return warehousesId;
    }

    public void setWarehousesId(String warehousesId) {
        this.warehousesId = warehousesId;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }

    public void setInventoryType(Long inventoryType)
    {
        this.inventoryType = inventoryType;
    }

    public Long getInventoryType()
    {
        return inventoryType;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId()
    {
        return orderId;
    }

    public void setMaterialId(String materialId)
    {
        this.materialId = materialId;
    }

    public String getMaterialId()
    {
        return materialId;
    }

    public void setBatchId(String batchId)
    {
        this.batchId = batchId;
    }

    public String getBatchId()
    {
        return batchId;
    }

    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId()
    {
        return locationId;
    }

    public void setOwnerId(String ownerId)
    {
        this.ownerId = ownerId;
    }

    public String getOwnerId()
    {
        return ownerId;
    }

    public void setQuantity(Long quantity)
    {
        this.quantity = quantity;
    }

    public Long getQuantity()
    {
        return quantity;
    }

    public void setLockedQuantity(Long lockedQuantity)
    {
        this.lockedQuantity = lockedQuantity;
    }

    public Long getLockedQuantity()
    {
        return lockedQuantity;
    }

    public void setUnitWeight(Long unitWeight)
    {
        this.unitWeight = unitWeight;
    }

    public Long getUnitWeight()
    {
        return unitWeight;
    }

    public void setTotalWeight(Long totalWeight)
    {
        this.totalWeight = totalWeight;
    }

    public Long getTotalWeight()
    {
        return totalWeight;
    }

    public void setTotalVolume(Long totalVolume)
    {
        this.totalVolume = totalVolume;
    }

    public Long getTotalVolume()
    {
        return totalVolume;
    }

    public void setProductionDate(Date productionDate)
    {
        this.productionDate = productionDate;
    }

    public Date getProductionDate()
    {
        return productionDate;
    }

    public void setExpirationDate(Date expirationDate)
    {
        this.expirationDate = expirationDate;
    }

    public Date getExpirationDate()
    {
        return expirationDate;
    }

    public void setInventoryStatus(Long inventoryStatus)
    {
        this.inventoryStatus = inventoryStatus;
    }

    public Long getInventoryStatus()
    {
        return inventoryStatus;
    }

    public void setLastInboundTime(Date lastInboundTime)
    {
        this.lastInboundTime = lastInboundTime;
    }

    public Date getLastInboundTime()
    {
        return lastInboundTime;
    }

    public void setLastOutboundTime(Date lastOutboundTime)
    {
        this.lastOutboundTime = lastOutboundTime;
    }

    public Date getLastOutboundTime()
    {
        return lastOutboundTime;
    }

    public void setIsUsed(Long isUsed)
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed()
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo)
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo()
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    public void setAlertType(String alertType)
    {
        this.alertType = alertType;
    }

    public String getAlertType()
    {
        return alertType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("inventoryType", getInventoryType())
                .append("orderId", getOrderId())
                .append("orderName", getOrderName())
                .append("materialId", getMaterialId())
                .append("materialName", getMaterialName())
                .append("batchId", getBatchId())
                .append("warehousesId", getWarehousesId())
                .append("warehousesName", getWarehousesName())
                .append("warehousesCode", getWarehousesCode())
                .append("locationId", getLocationId())
                .append("locationName", getLocationName())
                .append("ownerId", getOwnerId())
                .append("ownerName", getOwnerName())
                .append("quantity", getQuantity())
                .append("lockedQuantity", getLockedQuantity())
                .append("unitWeight", getUnitWeight())
                .append("totalWeight", getTotalWeight())
                .append("totalVolume", getTotalVolume())
                .append("productionDate", getProductionDate())
                .append("expirationDate", getExpirationDate())
                .append("inventoryStatus", getInventoryStatus())
                .append("lastInboundTime", getLastInboundTime())
                .append("lastOutboundTime", getLastOutboundTime())
                .append("isUsed", getIsUsed())
                .append("sortNo", getSortNo())
                .append("createTime", getCreateTime())
                .append("createUserCode", getCreateUserCode())
                .append("updateTime", getUpdateTime())
                .append("updateUserCode", getUpdateUserCode())
                .append("alertType", getAlertType())
                .toString();
    }
}
