package com.ruoyi.inventory.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.inventory.domain.Inventory;
import com.ruoyi.inventory.domain.vo.inboundVO.InboundTemplateVO;
import com.ruoyi.inventory.domain.vo.OutboundTemplateVO;
import org.springframework.beans.BeanUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.OutboundOrders;
import com.ruoyi.inventory.service.IOutboundOrdersService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 出库单主Controller
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@RestController
@RequestMapping("/inventory/orders")
public class OutboundOrdersController extends BaseController
{
    @Autowired
    private IOutboundOrdersService outboundOrdersService;

    /**
     * 查询出库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:list')")
    @GetMapping("/list")
    public TableDataInfo list(OutboundOrders outboundOrders)
    {
        startPage();
        List<OutboundOrders> list = outboundOrdersService.selectOutboundOrdersList(outboundOrders);
        return getDataTable(list);
    }

    /**
     * 导出出库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:export')")
    @Log(title = "出库单主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, OutboundOrders outboundOrders)
    {
        List<OutboundTemplateVO> list = outboundOrdersService.selectOutboundOrdersExportList(outboundOrders);
        ExcelUtil<OutboundTemplateVO> util = new ExcelUtil<OutboundTemplateVO>(OutboundTemplateVO.class);
        util.exportExcel(response, list, "出库单主数据");
    }

    /**
     * 获取出库单主详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(outboundOrdersService.selectOutboundOrdersById(id));
    }

    /**
     * 出货
     */
    @PreAuthorize("@ss.hasPermi('inventory:inventory:edit')")
    @Log(title = "出货", businessType = BusinessType.UPDATE)
    @PostMapping("/ship")
    public AjaxResult Ship(@RequestBody OutboundOrders outboundOrders )
    {
        return toAjax(outboundOrdersService.ship(outboundOrders));
    }

    /**
     * 新增出库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:add')")
    @Log(title = "出库单主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody OutboundOrders outboundOrders)
    {
        return toAjax(outboundOrdersService.insertOutboundOrders(outboundOrders));
    }

    /**
     * 修改出库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:edit')")
    @Log(title = "出库单主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody OutboundOrders outboundOrders)
    {
        return toAjax(outboundOrdersService.updateOutboundOrders(outboundOrders));
    }

    /**
     * 删除出库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:orders:remove')")
    @Log(title = "出库单主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(outboundOrdersService.deleteOutboundOrdersByIds(ids));
    }


    @PreAuthorize("@ss.hasPermi('inventory:orders:query')")
    @PostMapping("/outboundOrdersTopTenByQuantity")
    public TableDataInfo outboundOrdersTopTenByQuantity(){
        List<Map<String,String>> resultMap = outboundOrdersService.outboundOrdersTopTenByQuantity();
        return getDataTable(resultMap);
    }

    @PreAuthorize("@ss.hasPermi('inventory:orders:query')")
    @PostMapping("/outboundOrdersTopTenByAmount")
    public TableDataInfo outboundOrdersTopTenByAmount(){
        List<Map<String,String>> resultMap = outboundOrdersService.outboundOrdersTopTenByAmount();
        return getDataTable(resultMap);
    }

    @PreAuthorize("@ss.hasPermi('inventory:orders:query')")
    @PostMapping("/outboundOrdersCount")
    public AjaxResult outboundOrdersCount(){
        Object resultMap = outboundOrdersService.outboundOrdersCount();
        return AjaxResult.success(resultMap);
    }
    /**
     * 下载入库单导入模板
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:importTemplate')")
    @Log(title = "入库导入模板", businessType = BusinessType.IMPORT)
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<OutboundTemplateVO> util = new ExcelUtil<OutboundTemplateVO>(OutboundTemplateVO.class);
        util.importTemplateExcel(response, "入库单及入库物料明细信息");
    }

    /**
     * 导入入库单物料明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:import')")
    @Log(title = "入库信息导入", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importTemplate(MultipartFile file , boolean updateSupport,Integer orderType) throws Exception
    {
        ExcelUtil<OutboundTemplateVO> util = new ExcelUtil<OutboundTemplateVO>(OutboundTemplateVO.class);
        List<OutboundTemplateVO> inboundOrders = util.importExcel(file.getInputStream());
        String operName = getUsername();
        String message = outboundOrdersService.importOutboundOrders(inboundOrders, updateSupport, operName,orderType);
        return success(message);
    }
}
