package com.ruoyi.inventory.domain;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库位对象 storage_locations
 *
 * @author ruoyi
 * @date 2025-12-01
 */
@Data
public class StorageLocations extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 库位编码 检索条件 */
    @Excel(name = "库位编码 检索条件")
    private String locationCode;


    /**
     * 上架顺序（数字越小优先级越高）
     */
    private String putawayOrder;

    /**
     * 拣货顺序（数字越小优先级越高）
     */
    private String pickingOrder;

    /**
     * 库位使用（
     */
    private Integer LocationUsage;
    /**
     * 库位处理状态（如：正常/冻结/锁定/禁用）
     */
    private String locationHandling;
    /**
     * 周转需求（如：高周转/中周转/低周转）
     */
    private String turnoverDemand;

    /**
     * 所属拣货区域（编码/名称）
     */
    private String pickingArea;
    /**
     * 是否允许混放产品（true=允许，false=不允许）
     */
    private String allowMixedProducts;

    /**
     * 是否允许混放批次（true=允许，false=不允许）
     */
    private String allowMixedBatches;

    /** 库位名称 检索条件 */
    @Excel(name = "库位名称 检索条件")
    private String locationName;

    /** 仓库编码 检索条件 */
    @Excel(name = "仓库编码 检索条件")
    private String warehousesCode;

    /** 库位类型 1-货架 2-地面 3-货位 4-专区 字典设置，检索条件 */
    @Excel(name = "库位类型 1-货架 2-地面 3-货位 4-专区 字典设置，检索条件")
    private Long locationType;

    /** 区域代码 */
    @Excel(name = "区域代码")
    private String zoneCode;

    /** 排 */
    @Excel(name = "排")
    private String rowCode;

    /** 列 */
    @Excel(name = "列")
    private String columnCode;

    /** 层 文字，检索条件 */
    @Excel(name = "层 文字，检索条件")
    private String layerCode;

    /** 库位容量(千克) */
    @Excel(name = "库位容量(千克)")
    private Long capacity;

    /** 体积容量(立方米) */
    @Excel(name = "体积容量(立方米)")
    private Long volumeCapacity;

    /** 允许存放的危险等级（逗号分隔） */
    @Excel(name = "允许存放的危险等级", readConverterExp = "逗=号分隔")
    private String allowedHazardLevels;

    /** 允许存放的分类ID（逗号分隔） */
    @Excel(name = "允许存放的分类ID", readConverterExp = "逗=号分隔")
    private String allowedCategoryIds;

    /** 允许存放的分类name（前端显示，逗号分隔） */
    private String allowedCategoryNames;

    /** 温区 */
    @Excel(name = "温区")
    private String temperatureZone;

    /** 库位属性 */
    @Excel(name = "应用状态1使用0未使用")
    private Long isEnabled;

    /** 应用数据1使用0删除 删除用 */
    private Long isUsed;

    /** 排序 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    /** 仓库id */
    private String warehousesId;

    /** 仓库名称 */
    private String warehousesName;

    private String loadingArea;

}