package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.ReturnOrderItems;
import com.ruoyi.inventory.service.IReturnOrderItemsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 退库单明细Controller
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@RestController
@RequestMapping("/inventory/return_order_items")
public class ReturnOrderItemsController extends BaseController
{
    @Autowired
    private IReturnOrderItemsService returnOrderItemsService;

    /**
     * 查询退库单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:list')")
    @GetMapping("/list")
    public TableDataInfo list(ReturnOrderItems returnOrderItems)
    {
        startPage();
        List<ReturnOrderItems> list = returnOrderItemsService.selectReturnOrderItemsList(returnOrderItems);
        return getDataTable(list);
    }

    /**
     * 导出退库单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:export')")
    @Log(title = "退库单明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ReturnOrderItems returnOrderItems)
    {
        List<ReturnOrderItems> list = returnOrderItemsService.selectReturnOrderItemsList(returnOrderItems);
        ExcelUtil<ReturnOrderItems> util = new ExcelUtil<ReturnOrderItems>(ReturnOrderItems.class);
        util.exportExcel(response, list, "退库单明细数据");
    }

    /**
     * 获取退库单明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(returnOrderItemsService.selectReturnOrderItemsById(id));
    }

    /**
     * 新增退库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:add')")
    @Log(title = "退库单明细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ReturnOrderItems returnOrderItems)
    {
        return toAjax(returnOrderItemsService.insertReturnOrderItems(returnOrderItems));
    }

    /**
     * 修改退库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:edit')")
    @Log(title = "退库单明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ReturnOrderItems returnOrderItems)
    {
        return toAjax(returnOrderItemsService.updateReturnOrderItems(returnOrderItems));
    }

    /**
     * 删除退库单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_order_items:remove')")
    @Log(title = "退库单明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(returnOrderItemsService.deleteReturnOrderItemsByIds(ids));
    }
}

