package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.ReturnOrderItems;

/**
 * 退库单明细Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface ReturnOrderItemsMapper 
{
    /**
     * 查询退库单明细
     * 
     * @param id 退库单明细主键
     * @return 退库单明细
     */
    public ReturnOrderItems selectReturnOrderItemsById(String id);

    /**
     * 查询退库单明细列表
     * 
     * @param returnOrderItems 退库单明细
     * @return 退库单明细集合
     */
    public List<ReturnOrderItems> selectReturnOrderItemsList(ReturnOrderItems returnOrderItems);

    /**
     * 新增退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    public int insertReturnOrderItems(ReturnOrderItems returnOrderItems);

    /**
     * 修改退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    public int updateReturnOrderItems(ReturnOrderItems returnOrderItems);

    /**
     * 删除退库单明细
     * 
     * @param id 退库单明细主键
     * @return 结果
     */
    public int deleteReturnOrderItemsById(String id);

    /**
     * 批量删除退库单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteReturnOrderItemsByIds(String[] ids);

    /**
     * 通过退库单号删除退库单明细
     * 
     * @param orderId 退库单号
     * @return 结果
     */
    public int deleteReturnOrderItemsByOrderId(String orderId);
}

