package com.ruoyi.inventory.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.OutboundOrderLogMapper;
import com.ruoyi.inventory.domain.OutboundOrderLog;
import com.ruoyi.inventory.service.IOutboundOrderLogService;

/**
 * 出库明细子（仅用于锁定数量统计）Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class OutboundOrderLogServiceImpl implements IOutboundOrderLogService 
{
    @Autowired
    private OutboundOrderLogMapper outboundOrderLogMapper;

    /**
     * 查询出库明细子（仅用于锁定数量统计）
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 出库明细子（仅用于锁定数量统计）
     */
    @Override
    public OutboundOrderLog selectOutboundOrderLogById(String id)
    {
        return outboundOrderLogMapper.selectOutboundOrderLogById(id);
    }

    /**
     * 查询出库明细子（仅用于锁定数量统计）列表
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 出库明细子（仅用于锁定数量统计）
     */
    @Override
    public List<OutboundOrderLog> selectOutboundOrderLogList(OutboundOrderLog outboundOrderLog)
    {
        return outboundOrderLogMapper.selectOutboundOrderLogList(outboundOrderLog);
    }

    /**
     * 新增出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    @Override
    public int insertOutboundOrderLog(OutboundOrderLog outboundOrderLog)
    {
        return outboundOrderLogMapper.insertOutboundOrderLog(outboundOrderLog);
    }
    /**
     * 修改出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    @Override
    public int updateOutboundOrderLog(OutboundOrderLog outboundOrderLog)
    {
        return outboundOrderLogMapper.updateOutboundOrderLog(outboundOrderLog);
    }

    /**
     * 批量删除出库明细子（仅用于锁定数量统计）
     * 
     * @param ids 需要删除的出库明细子（仅用于锁定数量统计）主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderLogByIds(String[] ids)
    {
        return outboundOrderLogMapper.deleteOutboundOrderLogByIds(ids);
    }

    /**
     * 删除出库明细子（仅用于锁定数量统计）信息
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 结果
     */
    @Override
    public int deleteOutboundOrderLogById(String id)
    {
        return outboundOrderLogMapper.deleteOutboundOrderLogById(id);
    }
}
