package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.UUID;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.inventory.mapper.ReturnOrderItemsMapper;
import com.ruoyi.inventory.domain.ReturnOrderItems;
import com.ruoyi.inventory.service.IReturnOrderItemsService;

/**
 * 退库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class ReturnOrderItemsServiceImpl implements IReturnOrderItemsService 
{
    @Autowired
    private ReturnOrderItemsMapper returnOrderItemsMapper;

    /**
     * 查询退库单明细
     * 
     * @param id 退库单明细主键
     * @return 退库单明细
     */
    @Override
    public ReturnOrderItems selectReturnOrderItemsById(String id)
    {
        return returnOrderItemsMapper.selectReturnOrderItemsById(id);
    }

    /**
     * 查询退库单明细列表
     * 
     * @param returnOrderItems 退库单明细
     * @return 退库单明细
     */
    @Override
    public List<ReturnOrderItems> selectReturnOrderItemsList(ReturnOrderItems returnOrderItems)
    {
        return returnOrderItemsMapper.selectReturnOrderItemsList(returnOrderItems);
    }

    /**
     * 新增退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    @Override
    public int insertReturnOrderItems(ReturnOrderItems returnOrderItems)
    {
        if (StringUtils.isEmpty(returnOrderItems.getId())) {
            returnOrderItems.setId(UUID.randomUUID().toString());
        }
        returnOrderItems.setCreateTime(DateUtils.getNowDate());
        if (returnOrderItems.getIsUsed() == null) {
            returnOrderItems.setIsUsed(1);
        }
        // 自动计算金额
        if (returnOrderItems.getActualQuantity() != null && returnOrderItems.getUnitPrice() != null) {
            returnOrderItems.setTotalAmount(returnOrderItems.getActualQuantity() * returnOrderItems.getUnitPrice());
        }
        return returnOrderItemsMapper.insertReturnOrderItems(returnOrderItems);
    }

    /**
     * 修改退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    @Override
    public int updateReturnOrderItems(ReturnOrderItems returnOrderItems)
    {
        returnOrderItems.setUpdateTime(DateUtils.getNowDate());
        // 自动计算金额
        if (returnOrderItems.getActualQuantity() != null && returnOrderItems.getUnitPrice() != null) {
            returnOrderItems.setTotalAmount(returnOrderItems.getActualQuantity() * returnOrderItems.getUnitPrice());
        }
        return returnOrderItemsMapper.updateReturnOrderItems(returnOrderItems);
    }

    /**
     * 批量删除退库单明细
     * 
     * @param ids 需要删除的退库单明细主键
     * @return 结果
     */
    @Override
    public int deleteReturnOrderItemsByIds(String[] ids)
    {
        return returnOrderItemsMapper.deleteReturnOrderItemsByIds(ids);
    }

    /**
     * 删除退库单明细信息
     * 
     * @param id 退库单明细主键
     * @return 结果
     */
    @Override
    public int deleteReturnOrderItemsById(String id)
    {
        return returnOrderItemsMapper.deleteReturnOrderItemsById(id);
    }
}

