package com.ruoyi.inventory.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 仓库对象 warehouses
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
@Data
public class Warehouses extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 仓库编码 检索条件 */
    @Excel(name = "仓库编码 检索条件")
    private String warehousesCode;

    /** 仓库名称 检索条件 */
    @Excel(name = "仓库名称 检索条件")
    private String warehousesName;

    /** 仓库类型1-普通仓 2-危险品仓 3-冷藏仓 字典设置，检索条件 */
    @Excel(name = "仓库类型1-普通仓 2-危险品仓 3-冷藏仓 字典设置，检索条件")
    private Long warehouseType;

    /** 仓库地点 检索条件 */
    @Excel(name = "仓库地点 检索条件")
    private String address;

    /** 仓库区域 */
    @Excel(name = "仓库区域")
    private Long area;

    /** 仓库容量 */
    @Excel(name = "仓库容量")
    private Long capacity;

    /** 仓库管理员 文字，检索条件 */
    @Excel(name = "仓库管理员 文字，检索条件")
    private String manager;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String contactPhone;

    /** 应用状态1使用0未使用 */
    @Excel(name = "应用状态1使用0未使用")
    private Long isEnabled;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    private String localId;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setWarehousesCode(String warehousesCode) 
    {
        this.warehousesCode = warehousesCode;
    }

    public String getWarehousesCode() 
    {
        return warehousesCode;
    }

    public void setWarehousesName(String warehousesName) 
    {
        this.warehousesName = warehousesName;
    }

    public String getWarehousesName() 
    {
        return warehousesName;
    }

    public void setWarehouseType(Long warehouseType) 
    {
        this.warehouseType = warehouseType;
    }

    public Long getWarehouseType() 
    {
        return warehouseType;
    }

    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }

    public void setArea(Long area) 
    {
        this.area = area;
    }

    public Long getArea() 
    {
        return area;
    }

    public void setCapacity(Long capacity) 
    {
        this.capacity = capacity;
    }

    public Long getCapacity() 
    {
        return capacity;
    }

    public void setManager(String manager) 
    {
        this.manager = manager;
    }

    public String getManager() 
    {
        return manager;
    }

    public void setContactPhone(String contactPhone) 
    {
        this.contactPhone = contactPhone;
    }

    public String getContactPhone() 
    {
        return contactPhone;
    }

    public void setIsEnabled(Long isEnabled) 
    {
        this.isEnabled = isEnabled;
    }

    public Long getIsEnabled() 
    {
        return isEnabled;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("warehousesCode", getWarehousesCode())
            .append("warehousesName", getWarehousesName())
            .append("warehouseType", getWarehouseType())
            .append("address", getAddress())
            .append("area", getArea())
            .append("capacity", getCapacity())
            .append("manager", getManager())
            .append("contactPhone", getContactPhone())
            .append("isEnabled", getIsEnabled())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
