package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 出库订单物料统计汇总VO
 *
 * @author ruoyi
 * @date 2025-12-10
 */
@Data
public class OutboundOrdersSummaryVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    // ========== 物料基础信息（来自materials表） ==========
    /** 物料ID */
    @Excel(name = "物料ID")
    private String materialId;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** SAP编码 */
    @Excel(name = "SAP编码")
    private String sapNo;

    /** TS编码 */
    @Excel(name = "TS编码")
    private String tsCode;

    /** 危化品ID */
    @Excel(name = "危化品ID")
    private String hazardId;

    /** 物料规格 */
    @Excel(name = "物料规格")
    private String specification;

    /** 物料单位 */
    @Excel(name = "物料单位")
    private String materialUnit;

    /** 单重 */
    @Excel(name = "单重")
    private BigDecimal unitWeight;

    /** 包装重量 */
    @Excel(name = "包装重量")
    private BigDecimal packageWeight;

    private String itemStatus;
    private String unitPrice;

    /** 总重量 */
    @Excel(name = "总重量")
    private BigDecimal totalWeight;

    /** 体积 */
    @Excel(name = "体积")
    private BigDecimal volume;

    /** 保质期天数 */
    @Excel(name = "保质期天数")
    private Long shelfLifeDays;

    /** 存储温度 */
    @Excel(name = "存储温度")
    private String storageTemperature;

    /** 特殊要求 */
    @Excel(name = "特殊要求")
    private String specialRequirements;

    /** 物料排序号 */
    @Excel(name = "物料排序号")
    private Long sortNo;

    // ========== 统计计算字段（聚合查询） ==========
    /** 计划数量（汇总） */
    @Excel(name = "计划数量")
    private BigDecimal plannedQuantity;

    /** 实际数量（汇总） */
    @Excel(name = "实际数量")
    private BigDecimal actualQuantity;

    /** 总金额（汇总：单价*实际数量） */
    @Excel(name = "总金额")
    private BigDecimal totalAmount;

    // ========== 仓库信息（来自warehouses表） ==========
    /** 仓库ID */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 仓库名称 */
    @Excel(name = "仓库名称")
    private String warehouseName;

    // ========== 订单批次信息（来自outbound_order_items表） ==========
    /** 批次号 */
    @Excel(name = "批次号")
    private String batchCode;

    /** 子订单ID（出库单明细订单ID） */
    @Excel(name = "子订单ID")
    private String orderId;

    /** 主订单ID（出库单主表订单ID） */
    @Excel(name = "主订单ID")
    private String mainOrderId;

    // ========== 检索条件字段 ==========
    /** 开始日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /** 结束日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /** 库位ID（检索条件） */
    @Excel(name = "库位ID 检索条件")
    private String locationId;

    private String locationName;

}