package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.StorageLocationsCategory;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Update;

/**
 * 库位存放分类Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
public interface StorageLocationsCategoryMapper 
{
    /**
     * 查询库位存放分类
     * 
     * @param id 库位存放分类主键
     * @return 库位存放分类
     */
    public StorageLocationsCategory selectStorageLocationsCategoryById(String id);

    /**
     * 查询库位存放分类列表
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 库位存放分类集合
     */
    public List<StorageLocationsCategory> selectStorageLocationsCategoryList(StorageLocationsCategory storageLocationsCategory);

    /**
     * 新增库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    public int insertStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory);

    /**
     * 修改库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    public int updateStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory);

    /**
     * 删除库位存放分类
     * 
     * @param id 库位存放分类主键
     * @return 结果
     */
    public int deleteStorageLocationsCategoryById(String id);

    /**
     * 删除库位存放分类
     *
     * @param locationCode 库位存放分类主键
     * @return 结果
     */
    @Delete("delete from storage_locations_category where location_code = #{locationCode}")
    public int deleteStorageLocationsCategoryByLocationCode(String locationCode);
    /**
     * 批量删除库位存放分类
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStorageLocationsCategoryByIds(String[] ids);
    /**
     * 修改库位状态
     *
     * @param id 需要删除的数据主键集合
     * @return 结果
     */
    @Update("update storage_locations_category set is_enabled = 0 where warehouses_code=#{id}")
    public int updateStorageLocationsCategoryStatus(String id);
}
