package com.ruoyi.web.controller.inventory;

import java.util.List;

import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.common.utils.uuid.UUID;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.domain.vo.InboundTemplateVO;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.InboundOrders;
import com.ruoyi.inventory.service.IInboundOrdersService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 入库单主Controller
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/inbound")
public class InboundOrdersController extends BaseController
{
    @Autowired
    private IInboundOrdersService inboundOrdersService;

    /**
     * 查询入库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:list')")
    @GetMapping("/list")
    public TableDataInfo list(InboundOrders inboundOrders)
    {
        startPage();
        List<InboundOrders> list = inboundOrdersService.selectInboundOrdersList(inboundOrders);
        return getDataTable(list);
    }

    /**
     * 导出入库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:export')")
    @Log(title = "入库单主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, InboundOrders inboundOrders)
    {
        List<InboundOrders> list = inboundOrdersService.selectInboundOrdersList(inboundOrders);
        ExcelUtil<InboundOrders> util = new ExcelUtil<InboundOrders>(InboundOrders.class);
        util.exportExcel(response, list, "入库单主数据");
    }

    /**
     * 获取入库单主详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(inboundOrdersService.selectInboundOrdersById(id));
    }

    /**
     * 新增入库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:add')")
    @Log(title = "入库单主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody InboundOrders inboundOrders)
    {
        inboundOrders.setId(UUID.randomUUID().toString());
        return toAjax(inboundOrdersService.insertInboundOrders(inboundOrders));
    }

    /**
     * 修改入库单
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:edit')")
    @Log(title = "入库单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody InboundOrders inboundOrders)
    {
        return toAjax(inboundOrdersService.updateInboundOrders(inboundOrders));
    }

    /**
     * 删除入库单
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:remove')")
    @Log(title = "入库单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(inboundOrdersService.deleteInboundOrdersByIds(ids));
    }

    /**
     * 下载入库单导入模板
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:importTemplate')")
    @Log(title = "入库导入模板", businessType = BusinessType.IMPORT)
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<InboundTemplateVO> util = new ExcelUtil<InboundTemplateVO>(InboundTemplateVO.class);
        util.importTemplateExcel(response, "入库单及入库物料明细信息");
    }

    /**
     * 导入入库单物料明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:inbound:import')")
    @Log(title = "入库信息导入", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importTemplate(MultipartFile file , boolean updateSupport) throws Exception
    {
        ExcelUtil<InboundTemplateVO> util = new ExcelUtil<InboundTemplateVO>(InboundTemplateVO.class);
        List<InboundTemplateVO> inboundOrders = util.importExcel(file.getInputStream());
        String operName = getUsername();
        String message = inboundOrdersService.importInboundOrders(inboundOrders, updateSupport, operName);
        return success(message);
    }
}
