package com.ruoyi.inventory.domain.vo;

import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.util.Date;

@Data
public class InboundDetailsVO {
    private static final long serialVersionUID = 1L;

    // 基础物料字段
    private String materialId;

    @Excel(name = "物料SAP",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String sapNo;

    @Excel(name = "物料名",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String materialName;

    // 新增：TS编码（来自第一个SQL的m.ts_code）
    @Excel(name = "TS编码",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String tsCode;

    // 新增：危险等级ID（来自第一个SQL的m.hazard_id）
    @Excel(name = "危险等级ID",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String hazardId;

    // 新增：物料规格（来自第一个SQL的m.specification）
    @Excel(name = "物料规格",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String specification;

    // 新增：物料单位（来自第一个SQL的m.material_unit）
    @Excel(name = "物料单位",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String materialUnit;

    // 新增：单重（来自第一个SQL的m.unit_weight）
    @Excel(name = "物料单重",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double unitWeight;

    // 新增：计划入库数量（来自第一个SQL的SUM(ioi.planned_quantity)）
    @Excel(name = "计划入库数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long plannedQuantity;

    @Excel(name = "入库单号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String orderId;

    @Excel(name = "批次ID",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String batchId;

    private String warehouseId;

    @Excel(name = "仓库名",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String warehousesName;

    private String locationId;

    @Excel(name = "库位名称",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE) // 补充Excel注解
    private String locationName;

    @Excel(name = "入库数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualQuantity;

    @Excel(name = "件数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualPackages;

    @Excel(name = "标签颜色",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String labelColor;

    @Excel(name = "单价",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double unitPrice;

    @Excel(name = "入库物料总价",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double totalPrice;

    @Excel(name = "备注",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String remark;

    @Excel(name = "入库时间",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE) // 补充日期格式化
    private Date inboundDate;

    // 查询条件字段（无需Excel注解）
    private Date inboundDateStart;

    private Date inboundDateEnd;
}
