package com.ruoyi.inventory.domain.vo.inboundVO;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.util.Date;

/**
 * 入库单导入对象 inboundTemplate
 *
 * @author ZTW
 * @date 2025-12-02
 */
@Data
public class InboundTemplateVO extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /** 编号 */
    private String id;

    /** 入库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Date inboundDate;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "SAP No",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String sapNo;

    /** 货物名称 */
    @Excel(name = "物料名称",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String materialName;

    /** 货物名称 */
    @Excel(name = "TS Code",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String tsCode;

    /** 批次ID 检索条件 */
    @Excel(name = "批号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String batchId;

    /** 计划数量 */
    @Excel(name = "计划数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long plannedQuantity;

    @Excel(name = "件重",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double unitWeight;

    /** 约数 */
    @Excel(name = "约数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long divisor;

    /** 实际件数 */
    @Excel(name = "件数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualPackages;

    /** 实际数量 */
    @Excel(name = "实发数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private Long actualQuantity;

    /** 库位ID 检索条件 */
    @Excel(name = "库位",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String locationId;

    /** 仓库ID 暂无用 */
    @Excel(name = "仓库",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String warehouseId;

    /** 备注 */
    @Excel(name = "备注",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String remark;

    /** 库位ID 检索条件 */
//    @Excel(name = "收货库位")
    private String remark2;

    /** 标签颜色 字典，检索条件 */
    @Excel(name = "标签颜色",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long labelColor;

    /** 凭证号 检索条件 */
    @Excel(name = "凭证号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String voucherNumber;

    @Excel(name = "保温",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String keepWarm;

    @Excel(name = "危险类别",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String hazardId;

    /** 入库单号 检索条件 */
    @Excel(name = "单号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String systemNo;

    /** 货主ID */
    @Excel(name = "货主",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String ownerId;

    /** 入库类型 字典，检索条件 */
    @Excel(name = "贴标数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long labelQuantity;

    /** 订单类型 字典，检索条件 */
    @Excel(name = "订单类型",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String orderType;

    @Excel(name = "单件重量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double packageWeight;

    /** 单价 */
    @Excel(name = "单价",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double unitPrice;

    /** 收货人 */
//    @Excel(name = "收货人")
    private String receivedBy;

    /** 物料备注 */
//    @Excel(name = "物料备注")
//    private String remark2;

    /** 负责人 暂无用 */
//    @Excel(name = "负责人 暂无用")
    private String opUserName;

    /** 计划件数 暂无用 */
    //  @Excel(name = "件数")
    private Long plannedPackages;

    /** 排序号 */
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;


    private String updateUserCode;
}
