import request from '@/utils/request'

// 查询货主信息列表
export function listOwners(query) {
  return request({
    url: '/inventory/owners/list',
    method: 'get',
    params: query
  })
}

// 查询货主信息详细
export function getOwners(id) {
  return request({
    url: '/inventory/owners/' + id,
    method: 'get'
  })
}

// 新增货主信息
export function addOwners(data) {
  return request({
    url: '/inventory/owners',
    method: 'post',
    data: data
  })
}

// 修改货主信息
export function updateOwners(data) {
  return request({
    url: '/inventory/owners',
    method: 'put',
    data: data
  })
}

// 删除货主信息
export function delOwners(id) {
  return request({
    url: '/inventory/owners/' + id,
    method: 'delete'
  })
}
