package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.StocktakeItems;
import com.ruoyi.inventory.service.IStocktakeItemsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 盘点单明细Controller
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@RestController
@RequestMapping("/inventory/stocktakeItems")
public class StocktakeItemsController extends BaseController
{
    @Autowired
    private IStocktakeItemsService stocktakeItemsService;

    /**
     * 查询盘点单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:list')")
    @GetMapping("/list")
    public TableDataInfo list(StocktakeItems stocktakeItems)
    {
        startPage();
        List<StocktakeItems> list = stocktakeItemsService.selectStocktakeItemsList(stocktakeItems);
        return getDataTable(list);
    }

    /**
     * 导出盘点单明细列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:export')")
    @Log(title = "盘点单明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, StocktakeItems stocktakeItems)
    {
        List<StocktakeItems> list = stocktakeItemsService.selectStocktakeItemsList(stocktakeItems);
        ExcelUtil<StocktakeItems> util = new ExcelUtil<StocktakeItems>(StocktakeItems.class);
        util.exportExcel(response, list, "盘点单明细数据");
    }

    /**
     * 获取盘点单明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(stocktakeItemsService.selectStocktakeItemsById(id));
    }

    /**
     * 新增盘点单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:add')")
    @Log(title = "盘点单明细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody StocktakeItems stocktakeItems)
    {
        return toAjax(stocktakeItemsService.insertStocktakeItems(stocktakeItems));
    }

    /**
     * 修改盘点单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:edit')")
    @Log(title = "盘点单明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody StocktakeItems stocktakeItems)
    {
        return toAjax(stocktakeItemsService.updateStocktakeItems(stocktakeItems));
    }

    /**
     * 删除盘点单明细
     */
    @PreAuthorize("@ss.hasPermi('inventory:stocktakeItems:remove')")
    @Log(title = "盘点单明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(stocktakeItemsService.deleteStocktakeItemsByIds(ids));
    }
}
