package com.ruoyi.inventory.mapper;

import java.util.List;

import com.ruoyi.inventory.domain.OutboundOrderItems;
import com.ruoyi.inventory.domain.OutboundOrderLog;

/**
 * 出库明细子（仅用于锁定数量统计）Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface OutboundOrderLogMapper 
{
    /**
     * 查询出库明细子（仅用于锁定数量统计）
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 出库明细子（仅用于锁定数量统计）
     */
    public OutboundOrderLog selectOutboundOrderLogById(String id);


    /**
     * 查询出库明细子（仅用于锁定数量统计）列表
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 出库明细子（仅用于锁定数量统计）集合
     */
    public List<OutboundOrderLog> selectOutboundOrderLogList(OutboundOrderLog outboundOrderLog);


    /**
     * 查询出库明细子（仅用于锁定数量统计）列表
     *
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 出库明细子（仅用于锁定数量统计）集合
     */
    public Long selectLockedQuantityByInventory(String id);


    /**
     * 新增出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    public int insertOutboundOrderLog(OutboundOrderLog outboundOrderLog);

    /**
     * 修改出库明细子（仅用于锁定数量统计）
     * 
     * @param outboundOrderLog 出库明细子（仅用于锁定数量统计）
     * @return 结果
     */
    public int updateOutboundOrderLog(OutboundOrderLog outboundOrderLog);

    /**
     * 删除出库明细子（仅用于锁定数量统计）
     * 
     * @param id 出库明细子（仅用于锁定数量统计）主键
     * @return 结果
     */
    public int deleteOutboundOrderLogById(String id);

    /**
     * 批量删除出库明细子（仅用于锁定数量统计）
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOutboundOrderLogByOrdersId(String id);


    /**
     * 批量删除出库明细子（仅用于锁定数量统计）
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOutboundOrderLogByIds(String[] ids);


    /**
     * 批量新增出库单明细
     *
     * @param outboundOrderItemsList 出库单明细列表
     * @return 结果
     */
    public int batchOutboundOrderLog(List<OutboundOrderLog> outboundOrderLogs);

}
