package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.Stocktakes;
import com.ruoyi.inventory.domain.StocktakeItems;

/**
 * 盘点单主Mapper接口
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public interface StocktakesMapper
{
    /**
     * 查询盘点单主
     *
     * @param id 盘点单主主键
     * @return 盘点单主
     */
    public Stocktakes selectStocktakesById(String id);

    /**
     * 查询盘点单主列表
     *
     * @param stocktakes 盘点单主
     * @return 盘点单主集合
     */
    public List<Stocktakes> selectStocktakesList(Stocktakes stocktakes);

    /**
     * 新增盘点单主
     *
     * @param stocktakes 盘点单主
     * @return 结果
     */
    public int insertStocktakes(Stocktakes stocktakes);

    /**
     * 修改盘点单主
     *
     * @param stocktakes 盘点单主
     * @return 结果
     */
    public int updateStocktakes(Stocktakes stocktakes);

    /**
     * 删除盘点单主
     *
     * @param id 盘点单主主键
     * @return 结果
     */
    public int deleteStocktakesById(String id);

    /**
     * 逻辑-批量删除盘点单主
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStocktakesByIds(String[] ids);

    /**
     * 逻辑-批量删除盘点单明细
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStocktakeItemsByStocktakeIds(String[] ids);

    /**
     * 批量新增盘点单明细
     *
     * @param stocktakeItemsList 盘点单明细列表
     * @return 结果
     */
    public int batchStocktakeItems(List<StocktakeItems> stocktakeItemsList);


    /**
     * 通过盘点单主主键删除盘点单明细信息
     *
     * @param id 盘点单主ID
     * @return 结果
     */
    public int deleteStocktakeItemsByStocktakeId(String id);
}
