package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.inventory.domain.InboundOrderItems;

/**
 * 入库单明细Service接口
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public interface IInboundOrderItemsService 
{
    /**
     * 查询入库单明细
     * 
     * @param id 入库单明细主键
     * @return 入库单明细
     */
    public InboundOrderItems selectInboundOrderItemsById(String id);

    /**
     * 查询入库单明细列表
     * 
     * @param inboundOrderItems 入库单明细
     * @return 入库单明细集合
     */
    public List<InboundOrderItems> selectInboundOrderItemsList(InboundOrderItems inboundOrderItems);
    public List<InboundOrderItems> selectInboundOrderItemsListAndMaterialName(InboundOrderItems inboundOrderItems);
    /**
     * 新增入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    public int insertInboundOrderItems(InboundOrderItems inboundOrderItems);

    /**
     * 修改入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    public int updateInboundOrderItems(InboundOrderItems inboundOrderItems);

    /**
     * 批量删除入库单明细
     * 
     * @param ids 需要删除的入库单明细主键集合
     * @return 结果
     */
    public int deleteInboundOrderItemsByIds(String[] ids);

    /**
     * 删除入库单明细信息
     * 
     * @param id 入库单明细主键
     * @return 结果
     */
    public int deleteInboundOrderItemsById(String id);

    /**
     * 导入入库单明细信息
     *
     * @param  inboundOrderItems,isUpdateSupport,operName 入库单数据信息
     * @return 结果
     */
    public String importInboundOrderItems(List<InboundOrderItems> inboundOrderItems, Boolean isUpdateSupport, String operName);
}
