package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.StocktakeItemsMapper;
import com.ruoyi.inventory.domain.StocktakeItems;
import com.ruoyi.inventory.service.IStocktakeItemsService;

/**
 * 盘点单明细Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@Service
public class StocktakeItemsServiceImpl implements IStocktakeItemsService
{
    @Autowired
    private StocktakeItemsMapper stocktakeItemsMapper;

    /**
     * 查询盘点单明细
     *
     * @param id 盘点单明细主键
     * @return 盘点单明细
     */
    @Override
    public StocktakeItems selectStocktakeItemsById(String id)
    {
        return stocktakeItemsMapper.selectStocktakeItemsById(id);
    }

    /**
     * 查询盘点单明细列表
     *
     * @param stocktakeItems 盘点单明细
     * @return 盘点单明细
     */
    @Override
    public List<StocktakeItems> selectStocktakeItemsList(StocktakeItems stocktakeItems)
    {
        return stocktakeItemsMapper.selectStocktakeItemsList(stocktakeItems);
    }

    /**
     * 新增盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    @Override
    public int insertStocktakeItems(StocktakeItems stocktakeItems)
    {
        stocktakeItems.setCreateTime(DateUtils.getNowDate());
        return stocktakeItemsMapper.insertStocktakeItems(stocktakeItems);
    }

    /**
     * 修改盘点单明细
     *
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    @Override
    public int updateStocktakeItems(StocktakeItems stocktakeItems)
    {
//        stocktakeItems.setUpdateTime(DateUtils.getNowDate());
        return stocktakeItemsMapper.updateStocktakeItems(stocktakeItems);
    }

    /**
     * 批量删除盘点单明细
     *
     * @param ids 需要删除的盘点单明细主键
     * @return 结果
     */
    @Override
    public int deleteStocktakeItemsByIds(String[] ids)
    {
        return stocktakeItemsMapper.deleteStocktakeItemsByIds(ids);
    }

    /**
     * 删除盘点单明细信息
     *
     * @param id 盘点单明细主键
     * @return 结果
     */
    @Override
    public int deleteStocktakeItemsById(String id)
    {
        return stocktakeItemsMapper.deleteStocktakeItemsById(id);
    }
}
