package com.ruoyi.inventory.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.common.core.domain.entity.MaterialsCategory;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.common.utils.uuid.UUID;
import com.ruoyi.inventory.domain.StorageLocationsCategory;
import com.ruoyi.inventory.mapper.MaterialsCategoryMapper;
import com.ruoyi.inventory.mapper.MaterialsMapper;
import com.ruoyi.inventory.mapper.StorageLocationsCategoryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.StorageLocationsMapper;
import com.ruoyi.inventory.domain.StorageLocations;
import com.ruoyi.inventory.service.IStorageLocationsService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 库位Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-01
 */
@Service
public class StorageLocationsServiceImpl implements IStorageLocationsService
{
    @Autowired
    private StorageLocationsMapper storageLocationsMapper;
    @Autowired
    private StorageLocationsCategoryMapper storageLocationsCategoryMapper;
    @Autowired
    private MaterialsMapper materialsMapper;

    /**
     * 查询库位
     *
     * @param id 库位主键
     * @return 库位
     */
    @Override
    public StorageLocations selectStorageLocationsById(String id)
    {
        return storageLocationsMapper.selectStorageLocationsById(id);
    }

    @Override
    public List<StorageLocations> selectStorageLocationsByWarehousesCode(String warehousesCode) {
        return storageLocationsMapper.selectStorageLocationsByWarehousesCode(warehousesCode);
    }

    @Override
    public List<StorageLocations> selectStorageLocationsByWarehousesCodes(String[] warehousesCodes) {
        return storageLocationsMapper.selectStorageLocationsByWarehousesCodes(warehousesCodes);
    }

    /**
     * 查询库位列表
     *
     * @param storageLocations 库位
     * @return 库位
     */
    @Override
    public List<StorageLocations> selectStorageLocationsList(StorageLocations storageLocations)
    {
        List<StorageLocations> storageLocations1 = storageLocationsMapper.selectStorageLocationsList(storageLocations);
        for (StorageLocations storageLocations2 : storageLocations1){
            String AllowedCategoryName = "";
            if (storageLocations2.getAllowedCategoryIds() != null && !storageLocations2.getAllowedCategoryIds().isEmpty()){
                String[] AllowedCategoryIds = storageLocations2.getAllowedCategoryIds().split(",");
                for (String AllowedCategoryId : AllowedCategoryIds) {

                    Materials materials = materialsMapper.selectMaterialsByMaterialsCode(AllowedCategoryId);
                    if (materials != null && materials.getMaterialName() != null) {
                        String categoryName = materials.getMaterialName().trim(); // 去除首尾空格
                        if (AllowedCategoryName != "") {
                            AllowedCategoryName += ",";
                        }
                        AllowedCategoryName += categoryName;
                    }
                }
            }
            storageLocations2.setAllowedCategoryNames(AllowedCategoryName);
        }
        return storageLocations1;
    }

    /**
     * 新增库位
     *
     * @param storageLocations 库位
     * @return 结果
     */
    @Override
    public int insertStorageLocations(StorageLocations storageLocations)
    {
        storageLocations.setCreateTime(DateUtils.getNowDate());

        StorageLocationsCategory storageLocationsCategory = new StorageLocationsCategory();
        BeanUtils.copyBeanProp(storageLocationsCategory,storageLocations);
        String LocationsID = UUID.randomUUID().toString();
        storageLocations.setId(LocationsID);
        storageLocations.setCreateTime(DateUtils.getNowDate());
        storageLocations.setCreateUserCode(String.valueOf(SecurityUtils.getUserId()));
        storageLocationsCategory.setLocationCode(LocationsID);

        if (storageLocations.getAllowedCategoryIds() != null && !storageLocations.getAllowedCategoryIds().isEmpty()){
            String[] CategoryId = storageLocations.getAllowedCategoryIds().split(",");
            for (String categoryId : CategoryId) {
                storageLocationsCategory.setId(java.util.UUID.randomUUID().toString());
                storageLocationsCategory.setCategoryId(categoryId);
                storageLocationsCategory.setCreateTime(DateUtils.getNowDate());
                storageLocationsCategory.setCreateUserCode(String.valueOf(SecurityUtils.getUserId()));
                Materials materials = materialsMapper.selectMaterialsByMaterialsCode(categoryId);
                storageLocationsCategory.setCategoryName(materials.getMaterialName());
                storageLocationsCategoryMapper.insertStorageLocationsCategory(storageLocationsCategory);
            }
        }
        return storageLocationsMapper.insertStorageLocations(storageLocations);
    }

    /**
     * 修改库位
     *
     * @param storageLocations 库位
     * @return 结果
     */
    @Override
    public int updateStorageLocations(StorageLocations storageLocations)
    {
        storageLocations.setUpdateTime(DateUtils.getNowDate());
        storageLocations.setUpdateUserCode(String.valueOf(SecurityUtils.getUserId()));

        String LocationsID = storageLocations.getId();
        String LocationsCode = storageLocations.getLocationCode();
        StorageLocations storageLocations1 = storageLocationsMapper.selectStorageLocationsById(LocationsID);
        if (storageLocations1.getAllowedCategoryIds()!=storageLocations.getAllowedCategoryIds()||storageLocations1.getIsEnabled()!=storageLocations.getIsEnabled()){
            storageLocationsCategoryMapper.deleteStorageLocationsCategoryByLocationCode(LocationsID);

            String[] CategoryId = storageLocations.getAllowedCategoryIds().split(",");
            StorageLocationsCategory storageLocationsCategory = new StorageLocationsCategory();
            BeanUtils.copyBeanProp(storageLocationsCategory,storageLocations);

            storageLocationsCategory.setLocationCode(LocationsCode);
            for (String categoryId : CategoryId) {
                storageLocationsCategory.setId(java.util.UUID.randomUUID().toString());
                storageLocationsCategory.setCategoryId(categoryId);
                storageLocationsCategory.setUpdateTime(DateUtils.getNowDate());
                storageLocationsCategory.setUpdateUserCode(String.valueOf(SecurityUtils.getUserId()));
                Materials materials = materialsMapper.selectMaterialsByMaterialsCode(categoryId);
                storageLocationsCategory.setCategoryName(materials.getMaterialName());
                storageLocationsCategoryMapper.insertStorageLocationsCategory(storageLocationsCategory);
            }
        }

        return storageLocationsMapper.updateStorageLocations(storageLocations);
    }

    /**
     * 批量删除库位
     *
     * @param ids 需要删除的库位主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsByIds(String[] ids)
    {
        return storageLocationsMapper.deleteStorageLocationsByIds(ids);
    }

    /**
     * 删除库位信息
     *
     * @param id 库位主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsById(String id)
    {
        storageLocationsCategoryMapper.deleteStorageLocationsCategoryById(id);
        return storageLocationsMapper.deleteStorageLocationsById(id);
    }

    @Override
    public int updateLocationsCategoryStatus(String id)
    {
        storageLocationsCategoryMapper.updateStorageLocationsCategoryStatus(id);
        return storageLocationsMapper.updateStorageLocationsStatus(id);
    }

    /**
     * @description: 获取库位表 的 location_code 编码 location_name 做成字典
     * @author cs
     * @date 2025/12/4
     * @version 1.0
     */
    @Override
    public List<Map<String, Object>> getMapList(StorageLocations storageLocations)
    {
        return storageLocationsMapper.getMapList(storageLocations);
    }

    /**
     * 查询库位列表
     *
     * @param storageLocations 库位
     * @return 库位集合
     */
    @Override
    public List<StorageLocations> getStorageLocationsList(StorageLocations storageLocations) {
        return storageLocationsMapper.getStorageLocationsList(storageLocations);
    }
}
