package com.ruoyi.inventory.utils;

import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class CustomHeaderStyleStrategy extends AbstractVerticalCellStyleStrategy {
    @Override
    protected WriteCellStyle headCellStyle(CellWriteHandlerContext context) {
        WriteCellStyle headStyle = new WriteCellStyle();
        // 设置表头字体
        WriteFont headFont = new WriteFont();
        headFont.setBold(true); // 加粗
        headFont.setFontHeightInPoints((short)12); // 字号
        headFont.setFontName("微软雅黑"); // 字体
        headStyle.setWriteFont(headFont);
        // 设置表头背景色（如浅灰色）
        headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        // 设置水平居中
        headStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        // 设置垂直居中
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return headStyle;
    }

    // 如果需要，也可以重写 contentCellStyle 方法来定义数据行的样式
    @Override
    protected WriteCellStyle contentCellStyle(CellWriteHandlerContext context) {
        return super.contentCellStyle(context);
    }
}
