import request from '@/utils/request'

// 查询出库单主列表
export function listOrders(query) {
  return request({
    url: '/inventory/orders/list',
    method: 'get',
    params: query
  })
}

// 查询出库单主详细
export function getOrders(id) {
  return request({
    url: '/inventory/orders/' + id,
    method: 'get'
  })
}

// 新增出库单主
export function addOrders(data) {
  return request({
    url: '/inventory/orders',
    method: 'post',
    data: data
  })
}

// 修改出库单主
export function updateOrders(data) {
  return request({
    url: '/inventory/orders',
    method: 'put',
    data: data
  })
}

// 删除出库单主
export function delOrders(id) {
  return request({
    url: '/inventory/orders/' + id,
    method: 'delete'
  })
}

// 查询仓库库存列表
export function listWarehouseInventory(warehouseId) {
  return request({
    url: '/inventory/items/list',
    method: 'get',
    params: { warehouseId: warehouseId }
  })
}

export function ship(data) {
  return request({
    url: '/inventory/orders/ship',
    method: 'post',
    data: data
  })
}

export function outboundOrdersTopTenByQuantity() {
  return request({
    url: '/inventory/orders/outboundOrdersTopTenByQuantity',
    method: 'post'
  })
}

export function outboundOrdersTopTenByAmount() {
  return request({
    url: '/inventory/orders/outboundOrdersTopTenByAmount',
    method: 'post'
  })
}