package com.ruoyi.inventory.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 盘点单明细对象 stocktake_items
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public class StocktakeItems extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 盘点单号 检索条件 */
    @Excel(name = "盘点单号 检索条件")
    private String stocktakeId;

    /** 库存表Id */
    @Excel(name = "库存表Id")
    private String inventoryId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物ID 字典，检索条件")
    private String materialId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次ID 检索条件")
    private String batchCode;

    /** 仓库ID 检索条件 */
    @Excel(name = "仓库ID 检索条件")
    private String warehouseId;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID 检索条件")
    private String locationId;

    /** 系统数量 */
    @Excel(name = "系统数量")
    private Long systemQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Long actualQuantity;

    /** 差异数量 */
    @Excel(name = "差异数量")
    private Long varianceQuantity;

    /** 差异金额 */
    @Excel(name = "差异金额")
    private Long varianceAmount;

    /** 盘点状态1-计划中 1-盘点中 2-已完成 字典，检索条件 */
    @Excel(name = "盘点状态1-计划中 1-盘点中 2-已完成 字典，检索条件")
    private String stocktakeStatus;

    /** 盘点人 */
    @Excel(name = "盘点人")
    private String countedBy;

    /** 盘点时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "盘点时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date countedAt;

    /** 是否已调整0否1是 */
    @Excel(name = "是否已调整0否1是")
    private Long adjusted;

    /** 调整原因 */
    @Excel(name = "调整原因")
    private String adjustmentReason;

    /** 调整人 */
    @Excel(name = "调整人")
    private String adjustedBy;

    /** 调整时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "调整时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date adjustedAt;

    /** 开始时间 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 暂无用 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间 暂无用", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 盘点物料范围 暂无用 */
    @Excel(name = "盘点物料范围 暂无用")
    private String materialRange;

    /** 盘点库位范围 暂无用 */
    @Excel(name = "盘点库位范围 暂无用")
    private String locationRange;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 单价 */
    @Excel(name = "单价")
    private double unitPrice;

    public double getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getInventoryId() {
        return inventoryId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }
    public void setStocktakeId(String stocktakeId)
    {
        this.stocktakeId = stocktakeId;
    }

    public String getStocktakeId()
    {
        return stocktakeId;
    }
    public void setMaterialId(String materialId)
    {
        this.materialId = materialId;
    }

    public String getMaterialId()
    {
        return materialId;
    }
    public void setBatchCode(String batchCode)
    {
        this.batchCode = batchCode;
    }

    public String getBatchCode()
    {
        return batchCode;
    }
    public void setWarehouseId(String warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId()
    {
        return warehouseId;
    }
    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId()
    {
        return locationId;
    }
    public void setSystemQuantity(Long systemQuantity)
    {
        this.systemQuantity = systemQuantity;
    }

    public Long getSystemQuantity()
    {
        return systemQuantity;
    }
    public void setActualQuantity(Long actualQuantity)
    {
        this.actualQuantity = actualQuantity;
    }

    public Long getActualQuantity()
    {
        return actualQuantity;
    }
    public void setVarianceQuantity(Long varianceQuantity)
    {
        this.varianceQuantity = varianceQuantity;
    }

    public Long getVarianceQuantity()
    {
        return varianceQuantity;
    }
    public void setVarianceAmount(Long varianceAmount)
    {
        this.varianceAmount = varianceAmount;
    }

    public Long getVarianceAmount()
    {
        return varianceAmount;
    }
    public void setStocktakeStatus(String stocktakeStatus)
    {
        this.stocktakeStatus = stocktakeStatus;
    }

    public String getStocktakeStatus()
    {
        return stocktakeStatus;
    }
    public void setCountedBy(String countedBy)
    {
        this.countedBy = countedBy;
    }

    public String getCountedBy()
    {
        return countedBy;
    }
    public void setCountedAt(Date countedAt)
    {
        this.countedAt = countedAt;
    }

    public Date getCountedAt()
    {
        return countedAt;
    }
    public void setAdjusted(Long adjusted)
    {
        this.adjusted = adjusted;
    }

    public Long getAdjusted()
    {
        return adjusted;
    }
    public void setAdjustmentReason(String adjustmentReason)
    {
        this.adjustmentReason = adjustmentReason;
    }

    public String getAdjustmentReason()
    {
        return adjustmentReason;
    }
    public void setAdjustedBy(String adjustedBy)
    {
        this.adjustedBy = adjustedBy;
    }

    public String getAdjustedBy()
    {
        return adjustedBy;
    }
    public void setAdjustedAt(Date adjustedAt)
    {
        this.adjustedAt = adjustedAt;
    }

    public Date getAdjustedAt()
    {
        return adjustedAt;
    }
    public void setStartTime(Date startTime)
    {
        this.startTime = startTime;
    }

    public Date getStartTime()
    {
        return startTime;
    }
    public void setEndTime(Date endTime)
    {
        this.endTime = endTime;
    }

    public Date getEndTime()
    {
        return endTime;
    }
    public void setMaterialRange(String materialRange)
    {
        this.materialRange = materialRange;
    }

    public String getMaterialRange()
    {
        return materialRange;
    }
    public void setLocationRange(String locationRange)
    {
        this.locationRange = locationRange;
    }

    public String getLocationRange()
    {
        return locationRange;
    }
    public void setIsUsed(Long isUsed)
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed()
    {
        return isUsed;
    }
    public void setSortNo(Long sortNo)
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo()
    {
        return sortNo;
    }
    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }
    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("stocktakeId", getStocktakeId())
            .append("materialId", getMaterialId())
            .append("batchCode", getBatchCode())
            .append("warehouseId", getWarehouseId())
            .append("locationId", getLocationId())
            .append("systemQuantity", getSystemQuantity())
            .append("actualQuantity", getActualQuantity())
            .append("varianceQuantity", getVarianceQuantity())
            .append("varianceAmount", getVarianceAmount())
            .append("stocktakeStatus", getStocktakeStatus())
            .append("countedBy", getCountedBy())
            .append("countedAt", getCountedAt())
            .append("adjusted", getAdjusted())
            .append("adjustmentReason", getAdjustmentReason())
            .append("adjustedBy", getAdjustedBy())
            .append("adjustedAt", getAdjustedAt())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("materialRange", getMaterialRange())
            .append("locationRange", getLocationRange())
            .append("remark", getRemark())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
