package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 出库订单物料统计汇总VO
 *
 * @author ruoyi
 * @date 2025-12-10
 */
public class OutboundOrdersSummaryVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    // ========== 物料基础信息（来自materials表） ==========
    /** 物料ID */
    @Excel(name = "物料ID")
    private String materialId;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** SAP编码 */
    @Excel(name = "SAP编码")
    private String sapNo;

    /** TS编码 */
    @Excel(name = "TS编码")
    private String tsCode;

    /** 危化品ID */
    @Excel(name = "危化品ID")
    private String hazardId;

    /** 物料规格 */
    @Excel(name = "物料规格")
    private String specification;

    /** 物料单位 */
    @Excel(name = "物料单位")
    private String materialUnit;

    /** 单重 */
    @Excel(name = "单重")
    private BigDecimal unitWeight;

    /** 包装重量 */
    @Excel(name = "包装重量")
    private BigDecimal packageWeight;

    /** 总重量 */
    @Excel(name = "总重量")
    private BigDecimal totalWeight;

    /** 体积 */
    @Excel(name = "体积")
    private BigDecimal volume;

    /** 保质期天数 */
    @Excel(name = "保质期天数")
    private Long shelfLifeDays;

    /** 存储温度 */
    @Excel(name = "存储温度")
    private String storageTemperature;

    /** 特殊要求 */
    @Excel(name = "特殊要求")
    private String specialRequirements;

    /** 物料排序号 */
    @Excel(name = "物料排序号")
    private Long sortNo;

    // ========== 统计计算字段（聚合查询） ==========
    /** 计划数量（汇总） */
    @Excel(name = "计划数量")
    private BigDecimal plannedQuantity;

    /** 实际数量（汇总） */
    @Excel(name = "实际数量")
    private BigDecimal actualQuantity;

    /** 总金额（汇总：单价*实际数量） */
    @Excel(name = "总金额")
    private BigDecimal totalAmount;

    // ========== 仓库信息（来自warehouses表） ==========
    /** 仓库ID */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 仓库名称 */
    @Excel(name = "仓库名称")
    private String warehouseName;

    // ========== 订单批次信息（来自outbound_order_items表） ==========
    /** 批次号 */
    @Excel(name = "批次号")
    private String batchCode;

    /** 子订单ID（出库单明细订单ID） */
    @Excel(name = "子订单ID")
    private String orderId;

    /** 主订单ID（出库单主表订单ID） */
    @Excel(name = "主订单ID")
    private String mainOrderId;

    // ========== 检索条件字段 ==========
    /** 开始日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /** 结束日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /** 订单状态（检索条件） */
    @Excel(name = "订单状态 字典，检索条件")
    private Long orderStatus;

    /** 库位ID（检索条件） */
    @Excel(name = "库位ID 检索条件")
    private String locationId;

    // ========== Getter & Setter 方法 ==========
    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSapNo() {
        return sapNo;
    }

    public void setSapNo(String sapNo) {
        this.sapNo = sapNo;
    }

    public String getTsCode() {
        return tsCode;
    }

    public void setTsCode(String tsCode) {
        this.tsCode = tsCode;
    }

    public String getHazardId() {
        return hazardId;
    }

    public void setHazardId(String hazardId) {
        this.hazardId = hazardId;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }

    public BigDecimal getUnitWeight() {
        return unitWeight;
    }

    public void setUnitWeight(BigDecimal unitWeight) {
        this.unitWeight = unitWeight;
    }

    public BigDecimal getPackageWeight() {
        return packageWeight;
    }

    public void setPackageWeight(BigDecimal packageWeight) {
        this.packageWeight = packageWeight;
    }

    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public Long getShelfLifeDays() {
        return shelfLifeDays;
    }

    public void setShelfLifeDays(Long shelfLifeDays) {
        this.shelfLifeDays = shelfLifeDays;
    }

    public String getStorageTemperature() {
        return storageTemperature;
    }

    public void setStorageTemperature(String storageTemperature) {
        this.storageTemperature = storageTemperature;
    }

    public String getSpecialRequirements() {
        return specialRequirements;
    }

    public void setSpecialRequirements(String specialRequirements) {
        this.specialRequirements = specialRequirements;
    }

    public Long getSortNo() {
        return sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    public BigDecimal getPlannedQuantity() {
        return plannedQuantity;
    }

    public void setPlannedQuantity(BigDecimal plannedQuantity) {
        this.plannedQuantity = plannedQuantity;
    }

    public BigDecimal getActualQuantity() {
        return actualQuantity;
    }

    public void setActualQuantity(BigDecimal actualQuantity) {
        this.actualQuantity = actualQuantity;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getBatchCode() {
        return batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getMainOrderId() {
        return mainOrderId;
    }

    public void setMainOrderId(String mainOrderId) {
        this.mainOrderId = mainOrderId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Long orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    // ========== ToString 方法 ==========
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("materialId", getMaterialId())
                .append("materialName", getMaterialName())
                .append("sapNo", getSapNo())
                .append("tsCode", getTsCode())
                .append("hazardId", getHazardId())
                .append("specification", getSpecification())
                .append("materialUnit", getMaterialUnit())
                .append("unitWeight", getUnitWeight())
                .append("packageWeight", getPackageWeight())
                .append("totalWeight", getTotalWeight())
                .append("volume", getVolume())
                .append("shelfLifeDays", getShelfLifeDays())
                .append("storageTemperature", getStorageTemperature())
                .append("specialRequirements", getSpecialRequirements())
                .append("sortNo", getSortNo())
                .append("plannedQuantity", getPlannedQuantity())
                .append("actualQuantity", getActualQuantity())
                .append("totalAmount", getTotalAmount())
                .append("warehouseId", getWarehouseId())
                .append("warehouseName", getWarehouseName())
                .append("batchCode", getBatchCode())
                .append("orderId", getOrderId())
                .append("mainOrderId", getMainOrderId())
                .append("startDate", getStartDate())
                .append("endDate", getEndDate())
                .append("orderStatus", getOrderStatus())
                .append("locationId", getLocationId())
                .append("remark", getRemark())
                .append("createTime", getCreateTime())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}