package com.ruoyi.inventory.service.impl;

import java.util.List;
import java.util.UUID;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.inventory.domain.OutboundOrderLog;
import com.ruoyi.inventory.domain.StocktakeItems;
import com.ruoyi.inventory.mapper.OutboundOrderLogMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.InventoryMapper;
import com.ruoyi.inventory.domain.Inventory;
import com.ruoyi.inventory.service.IInventoryService;

/**
 * 库存Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-03
 */
@Service
public class InventoryServiceImpl implements IInventoryService
{
    @Autowired
    private InventoryMapper inventoryMapper;
    @Autowired
    private OutboundOrderLogMapper outboundOrderLogMapper;

    /**
     * 查询库存
     *
     * @param id 库存主键
     * @return 库存
     */
    @Override
    public Inventory selectInventoryById(String id)
    {
        return inventoryMapper.selectInventoryById(id);
    }

    /**
     * 查询库存列表
     *
     * @param inventory 库存
     * @return 库存
     */
    @Override
    public List<Inventory> selectInventoryList(Inventory inventory)
    {

        return inventoryMapper.selectInventoryList(inventory);
    }
    @Override
    public Inventory selectInventory(Inventory inventory)
    {
        Inventory inventory1 = inventoryMapper.selectInventory(inventory);
        OutboundOrderLog outboundOrderLog = new OutboundOrderLog();
        BeanUtils.copyProperties(inventory1,outboundOrderLog);
        inventory1.setLockedQuantity(outboundOrderLogMapper.selectLockedQuantity(outboundOrderLog));
        return inventory1;
    }

    /**
     * 新增库存
     *
     * @param inventory 库存
     * @return 结果
     */
    @Override
    public int insertInventory(Inventory inventory)
    {
        inventory.setCreateTime(DateUtils.getNowDate());
        return inventoryMapper.insertInventory(inventory);
    }

    @Override
    public int insertInventoryList(List<Inventory> inventoryList) {
        int count = 0;
        for (Inventory inventory : inventoryList) {
            inventory.setCreateTime(DateUtils.getNowDate());
            inventory.setId(UUID.randomUUID().toString());
            count = inventoryMapper.insertInventory(inventory);
        }
        return count;
    }

    /**
     * 修改库存
     *
     * @param inventory 库存
     * @return 结果
     */
    @Override
    public int updateInventory(Inventory inventory)
    {
        inventory.setUpdateTime(DateUtils.getNowDate());
        return inventoryMapper.updateInventory(inventory);
    }



    /**
     * 批量删除库存
     *
     * @param ids 需要删除的库存主键
     * @return 结果
     */
    @Override
    public int deleteInventoryByIds(String[] ids)
    {
        return inventoryMapper.deleteInventoryByIds(ids);
    }

    /**
     * 删除库存信息
     *
     * @param id 库存主键
     * @return 结果
     */
    @Override
    public int deleteInventoryById(String id)
    {
        return inventoryMapper.deleteInventoryById(id);
    }

    @Override
    public List<Inventory> listByMatreialId(String materialId) {
        return inventoryMapper.listByMatreialId(materialId);
    }

    /**
     * @description: 获取库存盘点详细信息
     * @author cs
     * @date 2025/12/3
     * @version 1.0
     */
    public List<StocktakeItems> selectstocktakeItemsList(){
        return inventoryMapper.selectstocktakeItemsList();
    }
}
