package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.util.Date;

/**
 * 出库单明细对象 outbound_order_items
 *
 * @author ruoyi
 * @date 2025-12-03
 */
@Data
public class OutboundTemplateVO extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 日期（入库日期） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Date inboundDate;

    /** SAP号 */
    @Excel(name = "SAP No",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String sapNo;

    /** 货物名称 */
    @Excel(name = "物料名称",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String materialName;

    /** 物料ID */
    private String materialId;


    /** TS Code */
    @Excel(name = "TS Code",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String tsCode;

    /** 批号 */
    @Excel(name = " 批号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String batchCode;

    /** 计划数量 */
    @Excel(name = "计划数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long plannedQuantity;

    /** 件重 */
    @Excel(name = "件重",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double pieceWeight;

    /** 约数 */
    @Excel(name = "约数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double divisor;

    /** 件数（实际件数） */
    @Excel(name = "件数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualPackages;


    /** 实发数量（实际数量） */
    @Excel(name = "实发数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private Long actualQuantity;

    /** 库位名称 */
    @Excel(name = "库位",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String locationName;

    /** 库位ID */
    private String locationId;

    /** 仓库ID */
    private String warehouseId;

    /** 仓库名称 */
    @Excel(name = "仓库",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String warehouseName;

    /** 备注 */
    @Excel(name = "备注",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String remark;

    /** 标签颜色 */
    @Excel(name = "标签颜色",dictType = "label_color",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long labelColor;

    /** 凭证号 */
    @Excel(name = "凭证号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String voucherNumber;

    /** 保温状态/类型 */
    @Excel(name = "保温",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String insulation;

    /** 危检类别（危险类别） */
    @Excel(name = "危险类别",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String dangerCheckType;

    /** 单号 */
    @Excel(name = "单号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String orderId;

    /** 系统编号（系统单号） */
    @Excel(name = "系统单号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String systemNo;


    /** 订单类型 */
    @Excel(name = "订单类型",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.YELLOW)
    private String orderTypeId;
    /** 货主ID */
    private String ownerId;

    /** 货主名称 */
    @Excel(name = "货主",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String ownerName;

    /** 目的地 */
    @Excel(name = "目的地",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String destination;

    /** 预留 */
    @Excel(name = "预留",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String reservation;

    /** 单个件重值（单件重量） */
    @Excel(name = "单件重量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long singlePieceWeight;

}