package com.ruoyi.inventory.mapper;

import com.ruoyi.inventory.domain.vo.InboundOutboundDetailVO;
import com.ruoyi.inventory.domain.vo.InboundOutboundStatisticsVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 出入库统计Mapper
 */
@Mapper
public interface InventoryStatisticsMapper {

    /**
     * 按物料汇总出入库统计
     *
     * @param query 查询条件
     * @return 汇总结果
     */
    List<InboundOutboundStatisticsVO> selectInboundOutboundStatistics(InboundOutboundStatisticsVO query);

    /**
     * 入库明细（按物料+批次）
     */
    List<InboundOutboundDetailVO> selectInboundDetails(InboundOutboundStatisticsVO query);

    /**
     * 出库明细（按物料+批次）
     */
    List<InboundOutboundDetailVO> selectOutboundDetails(InboundOutboundStatisticsVO query);
}

