package com.ruoyi.inventory.mapper;

import com.ruoyi.inventory.domain.Inventory;
import com.ruoyi.inventory.domain.TO.StocktakeItemsTo;
import com.ruoyi.inventory.domain.vo.InventoryExceedWarnVO;
import com.ruoyi.inventory.domain.vo.InventoryVo;

import java.util.List;


/**
 * 库存Mapper接口
 *
 * @author ruoyi
 * @date 2025-12-03
 */
public interface InventoryMapper
{
    /**
     * 查询库存
     *
     * @param id 库存主键
     * @return 库存
     */
    public Inventory selectInventoryById(String id);
    /**
     * 查询库存
     *
     * @param inventory 实体
     * @return 库存
     */
    public Inventory selectInventory(Inventory inventory);

    /**
     * 查询库存列表
     *
     * @param inventory 库存
     * @return 库存集合
     */
    public List<Inventory> selectInventoryList(Inventory inventory);

    /**
     * 新增库存
     *
     * @param inventory 库存
     * @return 结果
     */
    public int insertInventory(Inventory inventory);

    /**
     * 修改库存
     *
     * @param inventory 库存
     * @return 结果
     */
    public int updateInventory(Inventory inventory);



    /**
     * 删除库存
     *
     * @param id 库存主键
     * @return 结果
     */
    public int deleteInventoryById(String id);

    /**
     * 批量删除库存
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteInventoryByIds(String[] ids);

    public List<Inventory> listByMaterialId(String materialId);

    /**
     * @description: 获取库存盘点详细信息
     * @author cs
     * @date 2025/12/3
     * @version 1.0
     */
    List<StocktakeItemsTo> selectstocktakeItemsList();

    /**
     * 按物料汇总统计库存
     *
     * @param inventory 库存查询条件
     * @return 库存汇总统计集合
     */
    public List<com.ruoyi.inventory.domain.vo.InventorySummaryVO> selectInventorySummaryList(Inventory inventory);

    /**
     * 查询库存明细列表（根据物料标识及检索条件）
     *
     * @param inventory 库存查询条件
     * @return 库存明细集合
     */
    public List<Inventory> selectInventoryDetailList(Inventory inventory);

    /**
     * 查询库存明细列表（根据物料标识及检索条件）
     *
     * @param inventory 库存查询条件
     * @return 库存明细集合
     */
    public List<InventoryVo> selectInventoryVoList(Inventory inventory);

    /**
     * 统计物料库存超出预警库存数量
     *
     * @return 超出预警值物料信息集合
     */
    public List<InventoryExceedWarnVO>  selectInventoryExceedWarnList();

    public List<java.util.Map<String, String>> selectInventoryTopTenByAmount();
    public List<java.util.Map<String, String>> selectInventoryTopTenByQuantity();
}
