package com.ruoyi.inventory.mapper;

import java.util.List;
import java.util.Map;

import com.ruoyi.common.core.domain.entity.Materials;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;

/**
 * 物料Mapper接口
 *
 * @author ruoyi
 * @date 2025-11-28
 */
@Mapper
public interface MaterialsMapper
{
    /**
     * 查询物料
     *
     * @param id 物料主键
     * @return 物料
     */
    public Materials selectMaterialsById(String id);

    /**
     * 查询物料
     *
     * @param id 物料主键
     * @return 物料
     */
    public List<Materials> selectMaterialsBySapNo(String id);

    /**
     * 查询物料列表
     *
     * @param materials 物料
     * @return 物料集合
     */
    public List<Materials> selectMaterialsList(Materials materials);

    /**
     * 新增物料
     *
     * @param materials 物料
     * @return 结果
     */
    public int insertMaterials(Materials materials);

    /**
     * 修改物料
     *
     * @param materials 物料
     * @return 结果
     */
    public int updateMaterials(Materials materials);

    /**
     * 批量修改物料的使用状态
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int updateMaterialsIsUsedByIds(String[] ids);


    /**
     * 批量删除,修改物料的使用状态
     *
     * @param id 需要删除的数据主键集合
     * @return 结果
     */
    public List<Materials> selectMaterialsByCategory(String id);

    /**
     * @description: 获取物料 的 sap_no Name 做成字典
     * @author cs
     * @date 2025/12/4
     * @version 1.0
     */
    @MapKey("sap_no")
    public List<Map<String, Object>> getMapList();

    /**
     * 删除物料（暂无用）
     *
     * @param id 物料主键
     * @return 结果
     */
    public int deleteMaterialsById(String id);

    /**
     * 批量删除物料（暂无用）
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMaterialsByIds(String[] ids);
    /**
     * 获取物料sap和id map字典
     *
     * @return 结果
     */
    @MapKey("sap_no")
    public Map<String,Map<String,String>> selectMaterialIdAndSapMap();
}
