package com.ruoyi.common.core.domain.entity;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 物料对象 materials
 *
 * @author ruoyi
 * @date 2025-11-28
 */
public class Materials extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    @Excel(name = "NO.")
    private Long no;

    /** 货主 数据库暂无字段  */
    @Excel(name = "货主")
    private String ownerId;

    /** SAP物料号 检索条件 */
    @Excel(name = "产品代码")
    private String sapNo;

    /** 是否激活 Y-是 N-否 */
    @Excel(name = "激活")
    private Long isActive;

    /** 物料名称 检索条件 */
    @Excel(name = "中文描述")
    private String materialName;

    /** 物料名称 检索条件 */
    @Excel(name = "英文描述")
    private String materialEname;

    /** 总重量 */
    @Excel(name = "毛重")
    private Long totalWeight;

    /** 单位重量 */
    @Excel(name = "净重")
    private Long unitWeight;

    /** 包装重量 */
    @Excel(name = "皮重")
    private Long packageWeight;

    /** 体积 */
    @Excel(name = "体积")
    private Long volume;

    /** 单价 */
    @Excel(name = "单价")
    private Long unitPrice;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 物料编码 检索条件 */
    private String materialCode;

    /** TS Code 检索条件 */
//    @Excel(name = "TS Code")
    private String tsCode;

    /** 物料分类 检索条件 */
//    @Excel(name = "物料分类")
    private String categoryCode;

    /** 危险类别ID 字典 */
//    @Excel(name = "危险类别ID")
    private String hazardId;

    /** 规格型号 检索条件 */
//    @Excel(name = "规格型号")
    private String specification;

    /** 计量单位 字典 */
//    @Excel(name = "计量单位")
    private String materialUnit;

    /** 保质期天数 */
//    @Excel(name = "保质期天数")
    private Long shelfLifeDays;

    /** 存储温度要求 */
//    @Excel(name = "存储温度要求")
    private String storageTemperature;

    /** 特殊存储要求 */
//    @Excel(name = "特殊存储要求")
    private String specialRequirements;

    /** 是否批次管理 1-是 0-否 */
//    @Excel(name = "是否批次管理 1-是 0-否")
    private Long isBatchManaged;

    /** 是否序列号管理 1-是 0-否 */
//    @Excel(name = "是否序列号管理 1-是 0-否")
    private Long isSerialManaged;

    /** 最低库存 */
//    @Excel(name = "最低库存")
    private Long minStockLevel;

    /** 最高库存 */
//    @Excel(name = "最高库存")
    private Long maxStockLevel;

    /** 是否正在使用 1-是 0-否 */
//    @Excel(name = "是否正在使用 1-是 0-否")
    private Long isUsed;

    /** 风险等级 字典 */
//    @Excel(name = "风险等级")
    private String riskLevel;

    /** 排序 */
//    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    private String createUserCode;

    /** 排序号 */
    private String updateUserCode;

    // ======================== 仅新增这一个库存字段 ========================
    /** 库存数量（关联inventory表） */
    @Excel(name = "库存数量")
    private Long stock;

    // ======================== 原有所有getter/setter（完整保留） ========================
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getNo() {
        return no;
    }

    public void setNo(Long no) {
        this.no = no;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getSapNo() {
        return sapNo;
    }

    public void setSapNo(String sapNo) {
        this.sapNo = sapNo;
    }

    public Long getIsActive() {
        return isActive;
    }

    public void setIsActive(Long isActive) {
        this.isActive = isActive;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialEname() {
        return materialEname;
    }

    public void setMaterialEname(String materialEname) {
        this.materialEname = materialEname;
    }

    public Long getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(Long totalWeight) {
        this.totalWeight = totalWeight;
    }

    public Long getUnitWeight() {
        return unitWeight;
    }

    public void setUnitWeight(Long unitWeight) {
        this.unitWeight = unitWeight;
    }

    public Long getPackageWeight() {
        return packageWeight;
    }

    public void setPackageWeight(Long packageWeight) {
        this.packageWeight = packageWeight;
    }

    public Long getVolume() {
        return volume;
    }

    public void setVolume(Long volume) {
        this.volume = volume;
    }

    public Long getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Long unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Override
    public String getRemark() {
        return remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getTsCode() {
        return tsCode;
    }

    public void setTsCode(String tsCode) {
        this.tsCode = tsCode;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getHazardId() {
        return hazardId;
    }

    public void setHazardId(String hazardId) {
        this.hazardId = hazardId;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }

    public Long getShelfLifeDays() {
        return shelfLifeDays;
    }

    public void setShelfLifeDays(Long shelfLifeDays) {
        this.shelfLifeDays = shelfLifeDays;
    }

    public String getStorageTemperature() {
        return storageTemperature;
    }

    public void setStorageTemperature(String storageTemperature) {
        this.storageTemperature = storageTemperature;
    }

    public String getSpecialRequirements() {
        return specialRequirements;
    }

    public void setSpecialRequirements(String specialRequirements) {
        this.specialRequirements = specialRequirements;
    }

    public Long getIsBatchManaged() {
        return isBatchManaged;
    }

    public void setIsBatchManaged(Long isBatchManaged) {
        this.isBatchManaged = isBatchManaged;
    }

    public Long getIsSerialManaged() {
        return isSerialManaged;
    }

    public void setIsSerialManaged(Long isSerialManaged) {
        this.isSerialManaged = isSerialManaged;
    }

    public Long getMinStockLevel() {
        return minStockLevel;
    }

    public void setMinStockLevel(Long minStockLevel) {
        this.minStockLevel = minStockLevel;
    }

    public Long getMaxStockLevel() {
        return maxStockLevel;
    }

    public void setMaxStockLevel(Long maxStockLevel) {
        this.maxStockLevel = maxStockLevel;
    }

    public Long getIsUsed() {
        return isUsed;
    }

    public void setIsUsed(Long isUsed) {
        this.isUsed = isUsed;
    }

    public String getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        this.riskLevel = riskLevel;
    }

    public Long getSortNo() {
        return sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    public String getUpdateUserCode() {
        return updateUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) {
        this.updateUserCode = updateUserCode;
    }

    // ======================== 仅新增库存字段的getter/setter ========================
    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    @Override
    public String toString() {
        return "Materials{" +
                "id='" + id + '\'' +
                ", no=" + no +
                ", ownerId='" + ownerId + '\'' +
                ", sapNo='" + sapNo + '\'' +
                ", isActive=" + isActive +
                ", materialName='" + materialName + '\'' +
                ", materialEname='" + materialEname + '\'' +
                ", totalWeight=" + totalWeight +
                ", unitWeight=" + unitWeight +
                ", packageWeight=" + packageWeight +
                ", volume=" + volume +
                ", unitPrice=" + unitPrice +
                ", remark='" + remark + '\'' +
                ", materialCode='" + materialCode + '\'' +
                ", tsCode='" + tsCode + '\'' +
                ", categoryCode='" + categoryCode + '\'' +
                ", hazardId='" + hazardId + '\'' +
                ", specification='" + specification + '\'' +
                ", materialUnit='" + materialUnit + '\'' +
                ", shelfLifeDays=" + shelfLifeDays +
                ", storageTemperature='" + storageTemperature + '\'' +
                ", specialRequirements='" + specialRequirements + '\'' +
                ", isBatchManaged=" + isBatchManaged +
                ", isSerialManaged=" + isSerialManaged +
                ", minStockLevel=" + minStockLevel +
                ", maxStockLevel=" + maxStockLevel +
                ", isUsed=" + isUsed +
                ", riskLevel='" + riskLevel + '\'' +
                ", sortNo=" + sortNo +
                ", createUserCode='" + createUserCode + '\'' +
                ", updateUserCode='" + updateUserCode + '\'' +
                ", stock=" + stock +  // 仅追加这一行
                '}';
    }
}