package com.ruoyi.common.annotation;

import java.lang.annotation.*;

/**
 * 若依框架适配 - 方法串行执行注解
 * 标记该注解的方法，同一分组内串行执行，不同分组并行
 *
 * @author RuoYi
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SerialExecution {
    /**
     * 串行分组（默认空，全局串行）
     */
    String group() default "";

    /**
     * 是否公平锁（按线程等待顺序执行）
     */
    boolean fair() default false;
}