package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.common.core.domain.entity.MaterialsCategory;

/**
 * 物料分类Mapper接口
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public interface MaterialsCategoryMapper 
{
    /**
     * 查询物料分类
     * 
     * @param id 物料分类主键
     * @return 物料分类
     */
    public MaterialsCategory selectMaterialsCategoryById(String id);
    /**
     * 查询物料分类
     *
     * @param id 物料分类主键
     * @return 物料分类
     */
    public MaterialsCategory selectMaterialsCategoryByMaterialsCode(String id);
    /**
     * 查询物料分类列表
     * 
     * @param materialsCategory 物料分类
     * @return 物料分类集合
     */
    public List<MaterialsCategory> selectMaterialsCategoryList(MaterialsCategory materialsCategory);

    /**
     * 新增物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    public int insertMaterialsCategory(MaterialsCategory materialsCategory);

    /**
     * 修改物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    public int updateMaterialsCategory(MaterialsCategory materialsCategory);

    /**
     * 删除物料分类
     * 
     * @param id 物料分类主键
     * @return 结果
     */
    public int deleteMaterialsCategoryById(String id);

    /**
     * 批量删除物料分类
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMaterialsCategoryByIds(String[] ids);
}
