package com.ruoyi.inventory.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 出库订单物料统计汇总VO
 *
 * @author ruoyi
 * @date 2025-12-10
 */
@Data
public class OutboundOrdersSummaryVO extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    // ========== 物料基础信息（来自materials表） ==========
    /** 物料ID */
    private String materialId;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** SAP编码 */
    @Excel(name = "SAP物料号")
    private String sapNo;

    /** TS编码 */
    @Excel(name = "TS Code")
    private String tsCode;

    /** 危化品ID */
    @Excel(name = "危险类别")
    private String hazardId;

    /** 物料规格 */
    @Excel(name = "规格型号")
    private String specification;

    /** 物料单位 */
    @Excel(name = "计量单位")
    private String materialUnit;

    /** 单重 */
    @Excel(name = "单位重量")
    private BigDecimal unitWeight;

    // 移除表格中没有的Excel注解字段
    private String itemStatus;
    @Excel(name = "单价")
    private String unitPrice;

    // 以下字段表格无，全部移除@Excel注解
    private BigDecimal packageWeight;
    private BigDecimal totalWeight;
    private BigDecimal volume;
    private Long shelfLifeDays;
    private String storageTemperature;
    private String specialRequirements;
    private Long sortNo;

    /** 计划数量（汇总） */
    @Excel(name = "计划数量")
    private BigDecimal plannedQuantity;

    /** 实际数量（汇总） */
    @Excel(name = "实际数量")
    private BigDecimal actualQuantity;

    /** 总金额（汇总：单价*实际数量） */
    @Excel(name = "金额")
    private BigDecimal totalAmount;

    // 仓库ID表格无，移除Excel注解
    private String warehouseId;

    /** 仓库名称 */
    @Excel(name = "仓库")
    private String warehouseName;

    /** 批次号 */
    @Excel(name = "批次")
    private String batchCode;

    // 子订单ID表格无，移除Excel注解
    private String orderId;

    /** 主订单ID（出库单主表订单ID） */
    @Excel(name = "主订单号")
    private String mainOrderId;

    // ========== 检索条件字段 ==========
    /** 开始日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /** 结束日期（检索条件） */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    private String orderStatus;
    // 库位ID表格无，移除Excel注解
    private String locationId;

    /** 库位名称 */
    @Excel(name = "库位")
    private String locationName;

}