import request from '@/utils/request'

// 查询物料列表
export function listMaterials(query) {
  return request({
    url: '/inventory/materials/list',
    method: 'get',
    params: query
  })
}

// 查询物料详细
export function getMaterials(id) {
  return request({
    url: '/inventory/materials/' + id,
    method: 'get'
  })
}

// 新增物料
export function addMaterials(data) {
  return request({
    url: '/inventory/materials',
    method: 'post',
    data: data
  })
}

// 修改物料
export function updateMaterials(data) {
  return request({
    url: '/inventory/materials',
    method: 'put',
    data: data
  })
}

// 删除物料
export function delMaterials(id) {
  return request({
    url: '/inventory/materials/' + id,
    method: 'put'
  })
}

export function getMaterialsdicts() {
  return request({
    url: '/inventory/materials/getMapList',
    method: 'get'
  })
}
export function ListMaterialsInventory(query){
  return request({
    url: '/inventory/materials/ListMaterialsInventory',
    method: 'post',
    params: query
  })
}
