package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.InboundOrders;
import com.ruoyi.inventory.domain.InboundOrderItems;

/**
 * 入库单主Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public interface InboundOrdersMapper 
{
    /**
     * 查询入库单主
     * 
     * @param id 入库单主主键
     * @return 入库单主
     */
    public InboundOrders selectInboundOrdersById(String id);

    /**
     * 查询入库单主列表
     * 
     * @param inboundOrders 入库单主
     * @return 入库单主集合
     */
    public List<InboundOrders> selectInboundOrdersList(InboundOrders inboundOrders);

    /**
     * 新增入库单主
     * 
     * @param inboundOrders 入库单主
     * @return 结果
     */
    public int insertInboundOrders(InboundOrders inboundOrders);

    /**
     * 修改入库单主
     * 
     * @param inboundOrders 入库单主
     * @return 结果
     */
    public int updateInboundOrders(InboundOrders inboundOrders);

    /**
     * 删除入库单主
     * 
     * @param id 入库单主主键
     * @return 结果
     */
    public int deleteInboundOrdersById(String id);

    /**
     * 批量删除入库单主
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteInboundOrdersByIds(String[] ids);

    /**
     * 批量删除入库单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteInboundOrderItemsByOrderIds(String[] ids);
    
    /**
     * 批量新增入库单明细
     * 
     * @param inboundOrderItemsList 入库单明细列表
     * @return 结果
     */
    public int batchInboundOrderItems(List<InboundOrderItems> inboundOrderItemsList);
    

    /**
     * 通过入库单主主键删除入库单明细信息
     * 
     * @param id 入库单主ID
     * @return 结果
     */
    public int deleteInboundOrderItemsByOrderId(String id);
}
