import request from '@/utils/request'

// 查询仓库列表
export function listWarehouses(query) {
  return request({
    url: '/inventory/warehouses/list',
    method: 'get',
    params: query
  })
}

// 查询仓库详细
export function getWarehouses(id) {
  return request({
    url: '/inventory/warehouses/' + id,
    method: 'get'
  })
}

// 新增仓库
export function addWarehouses(data) {
  return request({
    url: '/inventory/warehouses',
    method: 'post',
    data: data
  })
}

// 修改仓库
export function updateWarehouses(data) {
  return request({
    url: '/inventory/warehouses',
    method: 'put',
    data: data
  })
}

// 删除仓库
export function delWarehouses(id) {
  return request({
    url: '/inventory/warehouses/' + id,
    method: 'delete'
  })
}

// 查询仓库列表（无权限限制，用于选择器）
export function listWarehousesForSelector(query) {
  return request({
    url: '/inventory/warehouses/listForSelector',
    method: 'get',
    params: query
  })
}
export function getMapList() {
  return request({
    url: '/inventory/warehouses/getMapList',
    method: 'get'
  })
}
