package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.ReturnOrders;
import com.ruoyi.inventory.domain.ReturnOrderItems;

/**
 * 退库单主Mapper接口
 * 
 * @author cy
 * @date 2025-12-03
 */
public interface ReturnOrdersMapper 
{
    /**
     * 查询退库单主
     * 
     * @param id 退库单主主键
     * @return 退库单主
     */
    public ReturnOrders selectReturnOrdersById(String id);

    /**
     * 查询退库单主列表
     * 
     * @param returnOrders 退库单主
     * @return 退库单主集合
     */
    public List<ReturnOrders> selectReturnOrdersList(ReturnOrders returnOrders);

    /**
     * 新增退库单主
     * 
     * @param returnOrders 退库单主
     * @return 结果
     */
    public int insertReturnOrders(ReturnOrders returnOrders);

    /**
     * 修改退库单主
     * 
     * @param returnOrders 退库单主
     * @return 结果
     */
    public int updateReturnOrders(ReturnOrders returnOrders);

    /**
     * 删除退库单主
     * 
     * @param id 退库单主主键
     * @return 结果
     */
    public int deleteReturnOrdersById(String id);

    /**
     * 批量删除退库单主
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteReturnOrdersByIds(String[] ids);

    /**
     * 批量删除退库单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteReturnOrderItemsByOrderIds(String[] ids);
    
    /**
     * 批量新增退库单明细
     * 
     * @param returnOrderItemsList 退库单明细列表
     * @return 结果
     */
    public int batchReturnOrderItems(List<ReturnOrderItems> returnOrderItemsList);
    

    /**
     * 通过退库单主主键删除退库单明细信息
     * 
     * @param orderId 退库单号
     * @return 结果
     */
    public int deleteReturnOrderItemsByOrderId(String orderId);

    /**
     * 批量确认退库单
     * @param ids
     * @return
     */
    public int confirmReturnOrdersByIds(String[] ids);
}

