package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.InventoryTransactionsMapper;
import com.ruoyi.inventory.domain.InventoryTransactions;
import com.ruoyi.inventory.service.IInventoryTransactionsService;

/**
 * 库存事务Service业务层处理
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@Service
public class InventoryTransactionsServiceImpl implements IInventoryTransactionsService
{
    @Autowired
    private InventoryTransactionsMapper inventoryTransactionsMapper;

    /**
     * 查询库存事务
     *
     * @param id 库存事务主键
     * @return 库存事务
     */
    @Override
    public InventoryTransactions selectInventoryTransactionsById(String id)
    {
        return inventoryTransactionsMapper.selectInventoryTransactionsById(id);
    }

    /**
     * 查询库存事务列表
     *
     * @param inventoryTransactions 库存事务
     * @return 库存事务
     */
    @Override
    public List<InventoryTransactions> selectInventoryTransactionsList(InventoryTransactions inventoryTransactions)
    {
        return inventoryTransactionsMapper.selectInventoryTransactionsList(inventoryTransactions);
    }


    /**
     * 新增库存事务
     *
     * @param inventoryTransactions 库存事务
     * @return 结果
     */
    @Override
    public int insertInventoryTransactions(InventoryTransactions inventoryTransactions)
    {
        String loginUserId = String.valueOf(SecurityUtils.getLoginUser().getUserId());//当前登录人
        inventoryTransactions.setIsUsed(1L);
        inventoryTransactions.setCreateUserCode(loginUserId);
        inventoryTransactions.setCreateTime(DateUtils.getNowDate());
        return inventoryTransactionsMapper.insertInventoryTransactions(inventoryTransactions);
    }

    /**
     * 修改库存事务
     *
     * @param inventoryTransactions 库存事务
     * @return 结果
     */
    @Override
    public int updateInventoryTransactions(InventoryTransactions inventoryTransactions)
    {
        inventoryTransactions.setUpdateTime(DateUtils.getNowDate());
        return inventoryTransactionsMapper.updateInventoryTransactions(inventoryTransactions);
    }

    /**
     * 批量删除库存事务
     *
     * @param ids 需要删除的库存事务主键
     * @return 结果
     */
    @Override
    public int deleteInventoryTransactionsByIds(String[] ids)
    {
        return inventoryTransactionsMapper.deleteInventoryTransactionsByIds(ids);
    }

    /**
     * 删除库存事务信息
     *
     * @param id 库存事务主键
     * @return 结果
     */
    @Override
    public int deleteInventoryTransactionsById(String id)
    {
        return inventoryTransactionsMapper.deleteInventoryTransactionsById(id);
    }
}
