package com.ruoyi.inventory.mapper;

import java.util.List;
import com.ruoyi.inventory.domain.StocktakeItems;

/**
 * 盘点单明细Mapper接口
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public interface StocktakeItemsMapper 
{
    /**
     * 查询盘点单明细
     * 
     * @param id 盘点单明细主键
     * @return 盘点单明细
     */
    public StocktakeItems selectStocktakeItemsById(String id);

    /**
     * 查询盘点单明细列表
     * 
     * @param stocktakeItems 盘点单明细
     * @return 盘点单明细集合
     */
    public List<StocktakeItems> selectStocktakeItemsList(StocktakeItems stocktakeItems);

    /**
     * 新增盘点单明细
     * 
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    public int insertStocktakeItems(StocktakeItems stocktakeItems);

    /**
     * 修改盘点单明细
     * 
     * @param stocktakeItems 盘点单明细
     * @return 结果
     */
    public int updateStocktakeItems(StocktakeItems stocktakeItems);

    /**
     * 删除盘点单明细
     * 
     * @param id 盘点单明细主键
     * @return 结果
     */
    public int deleteStocktakeItemsById(String id);

    /**
     * 批量删除盘点单明细
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStocktakeItemsByIds(String[] ids);
}
