package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.Owners;

/**
 * 货主信息Service接口
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public interface IOwnersService 
{
    /**
     * 查询货主信息
     * 
     * @param id 货主信息主键
     * @return 货主信息
     */
    public Owners selectOwnersById(String id);

    /**
     * 查询货主信息列表
     * 
     * @param owners 货主信息
     * @return 货主信息集合
     */
    public List<Owners> selectOwnersList(Owners owners);

    /**
     * 新增货主信息
     * 
     * @param owners 货主信息
     * @return 结果
     */
    public int insertOwners(Owners owners);


    /**
     * 新增货主信息
     *
     * @param ownersList 货主信息
     * @return 结果
     */
    public String importOwners(List<Owners> ownersList, Boolean isUpdateSupport, String operName);

    /**
     * 修改货主信息
     * 
     * @param owners 货主信息
     * @return 结果
     */
    public int updateOwners(Owners owners);

    /**
     * 批量删除货主信息
     * 
     * @param ids 需要删除的货主信息主键集合
     * @return 结果
     */
    public int deleteOwnersByIds(String[] ids);

    /**
     * 删除货主信息信息
     * 
     * @param id 货主信息主键
     * @return 结果
     */
    public int deleteOwnersById(String id);
}
