package com.ruoyi.inventory.service;

import java.util.List;
import java.util.Map;

import com.ruoyi.inventory.domain.Warehouses;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 仓库Service接口
 *
 * @author ruoyi
 * @date 2025-12-01
 */
public interface IWarehousesService
{
    /**
     * 查询仓库
     *
     * @param id 仓库主键
     * @return 仓库
     */
    public Warehouses selectWarehousesById(String id);

    /**
     * 查询仓库列表
     *
     * @param warehouses 仓库
     * @return 仓库集合
     */
    public List<Warehouses> selectWarehousesList(Warehouses warehouses);

    /**
     * 新增仓库
     *
     * @param warehouses 仓库
     * @return 结果
     */
    public int insertWarehouses(Warehouses warehouses);

    /**
     * 修改仓库
     *
     * @param warehouses 仓库
     * @return 结果
     */
    public int updateWarehouses(Warehouses warehouses);

    int updateWarehouseStatus(Warehouses warehouses);

    /**
     * 批量删除仓库
     *
     * @param ids 需要删除的仓库主键集合
     * @return 结果
     */
    public int deleteWarehousesByIds(String[] ids);

    /**
     * 删除仓库信息
     *
     * @param id 仓库主键
     * @return 结果
     */
    public int deleteWarehousesById(String id);

    /**
     * @description: 获取仓库 的 warehouses_code 仓库编码 warehouses_name 做成字典
     * @author cs
     * @date 2025/12/4
     * @version 1.0
     */
    public List<Map<String, Object>> getMapList();

}
