package com.ruoyi.inventory.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import com.ruoyi.common.core.domain.entity.Materials;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.InboundOrderItemsMapper;
import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.service.IInboundOrderItemsService;

/**
 * 入库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
@Service
public class InboundOrderItemsServiceImpl implements IInboundOrderItemsService 
{
    @Autowired
    private InboundOrderItemsMapper inboundOrderItemsMapper;
    /**
     * 查询入库单明细
     * 
     * @param id 入库单明细主键
     * @return 入库单明细
     */
    @Override
    public InboundOrderItems selectInboundOrderItemsById(String id)
    {
        return inboundOrderItemsMapper.selectInboundOrderItemsById(id);
    }

    /**
     * 查询入库单明细列表
     * 
     * @param inboundOrderItems 入库单明细
     * @return 入库单明细
     */
    @Override
    public List<InboundOrderItems> selectInboundOrderItemsList(InboundOrderItems inboundOrderItems)
    {
        return inboundOrderItemsMapper.selectInboundOrderItemsList(inboundOrderItems);
    }

    @Override
    public List<InboundOrderItems> selectInboundOrderItemsListAndMaterialName(InboundOrderItems inboundOrderItems) {
        return inboundOrderItemsMapper.selectInboundOrderItemsListAndMaterialName(inboundOrderItems);
    }

    /**
     * 新增入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    @Override
    public int insertInboundOrderItems(InboundOrderItems inboundOrderItems)
    {
        inboundOrderItems.setCreateTime(DateUtils.getNowDate());

        return inboundOrderItemsMapper.insertInboundOrderItems(inboundOrderItems);
    }

    /**
     * 修改入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    @Override
    public int updateInboundOrderItems(InboundOrderItems inboundOrderItems)
    {
        inboundOrderItems.setUpdateTime(DateUtils.getNowDate());
        return inboundOrderItemsMapper.updateInboundOrderItems(inboundOrderItems);
    }

    /**
     * 批量删除入库单明细
     * 
     * @param ids 需要删除的入库单明细主键
     * @return 结果
     */
    @Override
    public int deleteInboundOrderItemsByIds(String[] ids)
    {
        return inboundOrderItemsMapper.deleteInboundOrderItemsByIds(ids);
    }

    /**
     * 删除入库单明细信息
     * 
     * @param id 入库单明细主键
     * @return 结果
     */
    @Override
    public int deleteInboundOrderItemsById(String id)
    {
        return inboundOrderItemsMapper.deleteInboundOrderItemsById(id);
    }

    /**
     * 导入入库单明细信息
     *
     * @param  inboundOrderItemsList,isUpdateSupport,operName 入库单数据信息
     * @return 结果
     */
    @Override
    public String importInboundOrderItems(List<InboundOrderItems> inboundOrderItemsList, Boolean isUpdateSupport, String operName)
    {
        if (StringUtils.isNull(inboundOrderItemsList) || inboundOrderItemsList.size() == 0)
        {
            throw new ServiceException("导入用户数据不能为空！");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        Date now = DateUtils.getNowDate();
        Long userId = SecurityUtils.getUserId();
        String operId = userId.toString();
        for (InboundOrderItems inboundOrderItems : inboundOrderItemsList)
        {
            try
            {
                inboundOrderItems.setId(UUID.randomUUID().toString());
                // 填充创建人、创建时间、修改人、修改时间
                inboundOrderItems.setCreateBy(operId);
                inboundOrderItems.setCreateTime(now);
                // 填充创建用户编码和更新用户编码
                inboundOrderItems.setCreateUserCode(operId);
                // 设置默认值
                if (inboundOrderItems.getItemStatus() == null)
                {
                    inboundOrderItems.setItemStatus(1L); // 默认激活
                }
                if (inboundOrderItems.getIsUsed() == null)
                {
                    inboundOrderItems.setIsUsed(1L); // 默认未删除
                }
                if (inboundOrderItems.getSortNo() == null)
                {
                    inboundOrderItems.setSortNo(0L); // 默认排序号
                }
                inboundOrderItemsMapper.insertInboundOrderItems(inboundOrderItems);
                successNum++;
                successMsg.append("<br/>" + inboundOrderItems.getOrderId() + "入库单的" + successNum + "条入库单物料 " + inboundOrderItems.getMaterialId() + " 导入成功");
            }
            catch (Exception e)
            {
                failureNum++;
                String msg = "<br/>" + inboundOrderItems.getOrderId() + "入库单的"  + failureNum + "条物料 " + inboundOrderItems.getMaterialId() + " 导入失败：";
                failureMsg.append(msg + e.getMessage());

            }
        }
        if (failureNum > 0)
        {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确");
            throw new ServiceException(failureMsg.toString());
        }
        else
        {
            successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条，数据如下：");
        }
        return successMsg.toString();
    }
}
