package com.ruoyi.inventory.domain;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 入库单主对象 inbound_orders
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public class InboundOrders extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 入库单号 检索条件 */
    @Excel(name = "入库单号")
    private String orderId;

    /** 系统编号 检索条件 */
    @Excel(name = "系统编号")
    private String systemNo;

    /** 入库类型 字典，检索条件 */
    @Excel(name = "入库类型")
    private String orderTypeId;

    /** 批次ID 检索条件 */
    @Excel(name = "批次号")
    private String batchId;

    /** 仓库ID 暂无用 */
    @Excel(name = "源仓库")
    private String warehouseId;

    private String warehouseName;
    /** 货主ID */
    @Excel(name = "货主")
    private String ownerId;

    private String ownerName;

    /** 入库单状态1-草稿 2-已完成 3-已取消 字典，检索条件 */
    @Excel(name = "入库单状态")
    private Long orderStatus;

    /** 入库日期 日期无时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入库日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundDate;

    /** 订单类型 字典，检索条件 */
    @Excel(name = "订单类型")
    private String orderType;

    /** 计划量 暂无用 */
    @Excel(name = "计划量")
    private Long totalPlannedQuantity;

    /** 实际量 暂无用 */
    @Excel(name = "实际量")
    private Long totalActualQuantity;

    /** 总件数 暂无用 */
    @Excel(name = "总件数")
    private Long totalPackages;

    /** 负责人 暂无用 */
    @Excel(name = "负责人")
    private String opUserName;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    /** 入库单明细信息 */
    private List<InboundOrderItems> inboundOrderItemsList;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setSystemNo(String systemNo) 
    {
        this.systemNo = systemNo;
    }

    public String getSystemNo() 
    {
        return systemNo;
    }

    public void setOrderTypeId(String orderTypeId) 
    {
        this.orderTypeId = orderTypeId;
    }

    public String getOrderTypeId() 
    {
        return orderTypeId;
    }

    public void setBatchId(String batchId)
    {
        this.batchId = batchId;
    }

    public String getBatchId()
    {
        return batchId;
    }

    public void setWarehouseId(String warehouseId) 
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId() 
    {
        return warehouseId;
    }

    public void setOwnerId(String ownerId) 
    {
        this.ownerId = ownerId;
    }

    public String getOwnerId() 
    {
        return ownerId;
    }

    public void setOrderStatus(Long orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public Long getOrderStatus() 
    {
        return orderStatus;
    }

    public void setInboundDate(Date inboundDate) 
    {
        this.inboundDate = inboundDate;
    }

    public Date getInboundDate() 
    {
        return inboundDate;
    }

    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }

    public void setTotalPlannedQuantity(Long totalPlannedQuantity) 
    {
        this.totalPlannedQuantity = totalPlannedQuantity;
    }

    public Long getTotalPlannedQuantity() 
    {
        return totalPlannedQuantity;
    }

    public void setTotalActualQuantity(Long totalActualQuantity) 
    {
        this.totalActualQuantity = totalActualQuantity;
    }

    public Long getTotalActualQuantity() 
    {
        return totalActualQuantity;
    }

    public void setTotalPackages(Long totalPackages) 
    {
        this.totalPackages = totalPackages;
    }

    public Long getTotalPackages() 
    {
        return totalPackages;
    }

    public void setOpUserName(String opUserName) 
    {
        this.opUserName = opUserName;
    }

    public String getOpUserName() 
    {
        return opUserName;
    }

    public void setIsUsed(Long isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed() 
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    public List<InboundOrderItems> getInboundOrderItemsList()
    {
        return inboundOrderItemsList;
    }

    public void setInboundOrderItemsList(List<InboundOrderItems> inboundOrderItemsList)
    {
        this.inboundOrderItemsList = inboundOrderItemsList;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("orderId", getOrderId())
            .append("systemNo", getSystemNo())
            .append("orderTypeId", getOrderTypeId())
            .append("batchCode", getBatchId())
            .append("warehouseId", getWarehouseId())
            .append("ownerId", getOwnerId())
            .append("orderStatus", getOrderStatus())
            .append("inboundDate", getInboundDate())
            .append("orderType", getOrderType())
            .append("totalPlannedQuantity", getTotalPlannedQuantity())
            .append("totalActualQuantity", getTotalActualQuantity())
            .append("totalPackages", getTotalPackages())
            .append("remark", getRemark())
            .append("opUserName", getOpUserName())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .append("inboundOrderItemsList", getInboundOrderItemsList())
            .append("ownerName", getOwnerName())
            .toString();
    }
}
