package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.inventory.domain.Inventory;

/**
 * 库存Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IInventoryService 
{
    /**
     * 查询库存
     * 
     * @param id 库存主键
     * @return 库存
     */
    public Inventory selectInventoryById(String id);

    /**
     * 查询库存列表
     * 
     * @param inventory 库存
     * @return 库存集合
     */
    public List<Inventory> selectInventoryList(Inventory inventory);

    Inventory selectInventory(Inventory inventory);

    /**
     * 新增库存
     * 
     * @param inventory 库存
     * @return 结果
     */
    public int insertInventory(Inventory inventory);

    /**
     * 批量新增库存
     *
     * @param inventoryList 库存
     * @return 结果
     */
    public int insertInventoryList(List<Inventory> inventoryList);
    /**
     * 修改库存
     * 
     * @param inventory 库存
     * @return 结果
     */
    public int updateInventory(Inventory inventory);

    /**
     * 批量删除库存
     * 
     * @param ids 需要删除的库存主键集合
     * @return 结果
     */
    public int deleteInventoryByIds(String[] ids);

    /**
     * 删除库存信息
     * 
     * @param id 库存主键
     * @return 结果
     */
    public int deleteInventoryById(String id);

    public List<Inventory> listByMatreialId(String materialId);
}
