import request from '@/utils/request'

// 查询物料分类列表
export function listMaterials_category(query) {
  return request({
    url: '/inventory/materials_category/list',
    method: 'get',
    params: query
  })
}

// 查询物料分类详细
export function getMaterials_category(id) {
  return request({
    url: '/inventory/materials_category/' + id,
    method: 'get'
  })
}

// 新增物料分类
export function addMaterials_category(data) {
  return request({
    url: '/inventory/materials_category',
    method: 'post',
    data: data
  })
}

// 修改物料分类
export function updateMaterials_category(data) {
  return request({
    url: '/inventory/materials_category',
    method: 'put',
    data: data
  })
}

// 删除物料分类
export function delMaterials_category(id) {
  return request({
    url: '/inventory/materials_category/' + id,
    method: 'put'
  })
}

// 查询部门下拉树结构
export function categoryTreeSelect() {
  return request({
    url: '/inventory/materials_category/categoryTree',
    method: 'get'
  })
}
