package com.ruoyi.inventory.domain;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 退库单主对象 return_orders
 * 
 * @author cy
 * @date 2025-12-03
 */

@Data
public class ReturnOrders extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 退库单号 */
    @Excel(name = "退库单号")
    private String orderId;

    /** 退库日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "退库日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date returnDate;

    /** 退库类型1-TRDC退料 2-质量退料 3-多出退料 4-其他 不显示，默认1字典 */
    @Excel(name = "退库类型")
    private String returnType;

    /** 货主 */
    @Excel(name = "货主")
    private String ownerId;
    private String ownerName;

    /** 原出库单号 暂无用 */
    @Excel(name = "原出库单号")
    private String originalOrderId;

    /** 退库原因 */
    @Excel(name = "退库原因")
    private String returnReason;

    /** 1-草稿 2-已完成 字典，检索条件 */
    @Excel(name = "订单状态")
    private Integer orderStatus;

    /** 计划量 暂时无用 */
    @Excel(name = "计划量")
    private Integer totalPlannedQuantity;

    /** 实际量 暂时无用 */
    @Excel(name = "实际量")
    private Integer totalActualQuantity;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据")
    private Integer isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Integer sortNo;

    /** 创建人代码 */
    @Excel(name = "创建人代码")
    private String createUserCode;

    /** 更新人代码 */
    @Excel(name = "更新人代码")
    private String updateUserCode;


    /** 退库单明细信息 */
    private List<ReturnOrderItems> returnOrderItemsList;

    public void setId(String id) 
    {
        this.id = id;
    }

    public String getId() 
    {
        return id;
    }

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setReturnDate(Date returnDate) 
    {
        this.returnDate = returnDate;
    }

    public Date getReturnDate() 
    {
        return returnDate;
    }

    public void setReturnType(String returnType) 
    {
        this.returnType = returnType;
    }

    public String getReturnType() 
    {
        return returnType;
    }

    public void setOwnerId(String ownerId) 
    {
        this.ownerId = ownerId;
    }

    public String getOwnerId() 
    {
        return ownerId;
    }

    public void setOriginalOrderId(String originalOrderId) 
    {
        this.originalOrderId = originalOrderId;
    }

    public String getOriginalOrderId() 
    {
        return originalOrderId;
    }

    public void setReturnReason(String returnReason) 
    {
        this.returnReason = returnReason;
    }

    public String getReturnReason() 
    {
        return returnReason;
    }

    public void setOrderStatus(Integer orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public Integer getOrderStatus() 
    {
        return orderStatus;
    }

    public void setTotalPlannedQuantity(Integer totalPlannedQuantity) 
    {
        this.totalPlannedQuantity = totalPlannedQuantity;
    }

    public Integer getTotalPlannedQuantity() 
    {
        return totalPlannedQuantity;
    }

    public void setTotalActualQuantity(Integer totalActualQuantity) 
    {
        this.totalActualQuantity = totalActualQuantity;
    }

    public Integer getTotalActualQuantity() 
    {
        return totalActualQuantity;
    }

    public void setIsUsed(Integer isUsed) 
    {
        this.isUsed = isUsed;
    }

    public Integer getIsUsed() 
    {
        return isUsed;
    }

    public void setSortNo(Integer sortNo) 
    {
        this.sortNo = sortNo;
    }

    public Integer getSortNo() 
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode) 
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode() 
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) 
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode() 
    {
        return updateUserCode;
    }

    public List<ReturnOrderItems> getReturnOrderItemsList()
    {
        return returnOrderItemsList;
    }

    public void setReturnOrderItemsList(List<ReturnOrderItems> returnOrderItemsList)
    {
        this.returnOrderItemsList = returnOrderItemsList;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("orderId", getOrderId())
            .append("returnDate", getReturnDate())
            .append("returnType", getReturnType())
            .append("ownerId", getOwnerId())
            .append("originalOrderId", getOriginalOrderId())
            .append("returnReason", getReturnReason())
            .append("orderStatus", getOrderStatus())
            .append("totalPlannedQuantity", getTotalPlannedQuantity())
            .append("totalActualQuantity", getTotalActualQuantity())
            .append("remark", getRemark())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .append("returnOrderItemsList", getReturnOrderItemsList())
            .toString();
    }
}

