/**
 * 通用加载字典数据方法（支持动态参数）
 * @param {String} url 字典接口地址
 * @param {Object} request axios实例
 * @param {Object} params 请求参数（联动用）
 * @returns {Array} 字典数据
 */
export async function loadDictData(url, request, params = {}) {
  try {
    const res = await request({
      url,
      method: 'get',
      params // 新增：传递动态参数
    })
    return res?.data || res || []
  } catch (error) {
    console.error(`加载字典[${url}]失败：`, error)
    return []
  }
}

/**
 * 通用字典值转标签方法
 * @param {Array} dictData 字典数组
 * @param {String/Number} value 要匹配的值
 * @param {String} valueKey 字典值字段
 * @param {String} labelKey 字典标签字段
 * @returns {String} 匹配到的标签
 */
export function getDictLabel(dictData, value, valueKey = 'id', labelKey = 'name') {
  if (!value || !dictData || !Array.isArray(dictData) || dictData.length === 0) {
    return String(value || '')
  }
  const targetValue = String(value).trim()
  const matchItem = dictData.find(item => {
    return String(item[valueKey] || '').trim() === targetValue
  })
  return matchItem ? matchItem[labelKey] : targetValue
}
